/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.IpRuleItem;
import software.amazon.awssdk.services.workspaces.model.IpRuleListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizeIpRulesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, AuthorizeIpRulesRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(AuthorizeIpRulesRequest.getter(AuthorizeIpRulesRequest::groupId)).setter(AuthorizeIpRulesRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<List<IpRuleItem>> USER_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserRules").getter(AuthorizeIpRulesRequest.getter(AuthorizeIpRulesRequest::userRules)).setter(AuthorizeIpRulesRequest.setter(Builder::userRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpRuleItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, USER_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GroupId", GROUP_ID_FIELD);
            this.put("UserRules", USER_RULES_FIELD);
        }
    });
    private final String groupId;
    private final List<IpRuleItem> userRules;

    private AuthorizeIpRulesRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.userRules = builder.userRules;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final boolean hasUserRules() {
        return this.userRules != null && !(this.userRules instanceof SdkAutoConstructList);
    }

    public final List<IpRuleItem> userRules() {
        return this.userRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserRules() ? this.userRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeIpRulesRequest)) {
            return false;
        }
        AuthorizeIpRulesRequest other = (AuthorizeIpRulesRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && this.hasUserRules() == other.hasUserRules() && Objects.equals(this.userRules(), other.userRules());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizeIpRulesRequest").add("GroupId", (Object)this.groupId()).add("UserRules", this.hasUserRules() ? this.userRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "UserRules": {
                return Optional.ofNullable(clazz.cast(this.userRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeIpRulesRequest, T> g) {
        return obj -> g.apply((AuthorizeIpRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String groupId;
        private List<IpRuleItem> userRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeIpRulesRequest model) {
            super(model);
            this.groupId(model.groupId);
            this.userRules(model.userRules);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<IpRuleItem.Builder> getUserRules() {
            List<IpRuleItem.Builder> result = IpRuleListCopier.copyToBuilder(this.userRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserRules(Collection<IpRuleItem.BuilderImpl> userRules) {
            this.userRules = IpRuleListCopier.copyFromBuilder(userRules);
        }

        @Override
        public final Builder userRules(Collection<IpRuleItem> userRules) {
            this.userRules = IpRuleListCopier.copy(userRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(IpRuleItem ... userRules) {
            this.userRules(Arrays.asList(userRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(Consumer<IpRuleItem.Builder> ... userRules) {
            this.userRules(Stream.of(userRules).map(c -> (IpRuleItem)((IpRuleItem.Builder)IpRuleItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeIpRulesRequest build() {
            return new AuthorizeIpRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AuthorizeIpRulesRequest> {
        public Builder groupId(String var1);

        public Builder userRules(Collection<IpRuleItem> var1);

        public Builder userRules(IpRuleItem ... var1);

        public Builder userRules(Consumer<IpRuleItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

