/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.DefaultImportClientBrandingAttributes;
import software.amazon.awssdk.services.workspaces.model.IosImportClientBrandingAttributes;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportClientBrandingRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ImportClientBrandingRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ImportClientBrandingRequest.getter(ImportClientBrandingRequest::resourceId)).setter(ImportClientBrandingRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceTypeWindows").getter(ImportClientBrandingRequest.getter(ImportClientBrandingRequest::deviceTypeWindows)).setter(ImportClientBrandingRequest.setter(Builder::deviceTypeWindows)).constructor(DefaultImportClientBrandingAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWindows").build()}).build();
    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_OSX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceTypeOsx").getter(ImportClientBrandingRequest.getter(ImportClientBrandingRequest::deviceTypeOsx)).setter(ImportClientBrandingRequest.setter(Builder::deviceTypeOsx)).constructor(DefaultImportClientBrandingAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeOsx").build()}).build();
    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_ANDROID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceTypeAndroid").getter(ImportClientBrandingRequest.getter(ImportClientBrandingRequest::deviceTypeAndroid)).setter(ImportClientBrandingRequest.setter(Builder::deviceTypeAndroid)).constructor(DefaultImportClientBrandingAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeAndroid").build()}).build();
    private static final SdkField<IosImportClientBrandingAttributes> DEVICE_TYPE_IOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceTypeIos").getter(ImportClientBrandingRequest.getter(ImportClientBrandingRequest::deviceTypeIos)).setter(ImportClientBrandingRequest.setter(Builder::deviceTypeIos)).constructor(IosImportClientBrandingAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeIos").build()}).build();
    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_LINUX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceTypeLinux").getter(ImportClientBrandingRequest.getter(ImportClientBrandingRequest::deviceTypeLinux)).setter(ImportClientBrandingRequest.setter(Builder::deviceTypeLinux)).constructor(DefaultImportClientBrandingAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeLinux").build()}).build();
    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_WEB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceTypeWeb").getter(ImportClientBrandingRequest.getter(ImportClientBrandingRequest::deviceTypeWeb)).setter(ImportClientBrandingRequest.setter(Builder::deviceTypeWeb)).constructor(DefaultImportClientBrandingAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWeb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, DEVICE_TYPE_WINDOWS_FIELD, DEVICE_TYPE_OSX_FIELD, DEVICE_TYPE_ANDROID_FIELD, DEVICE_TYPE_IOS_FIELD, DEVICE_TYPE_LINUX_FIELD, DEVICE_TYPE_WEB_FIELD));
    private final String resourceId;
    private final DefaultImportClientBrandingAttributes deviceTypeWindows;
    private final DefaultImportClientBrandingAttributes deviceTypeOsx;
    private final DefaultImportClientBrandingAttributes deviceTypeAndroid;
    private final IosImportClientBrandingAttributes deviceTypeIos;
    private final DefaultImportClientBrandingAttributes deviceTypeLinux;
    private final DefaultImportClientBrandingAttributes deviceTypeWeb;

    private ImportClientBrandingRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.deviceTypeWindows = builder.deviceTypeWindows;
        this.deviceTypeOsx = builder.deviceTypeOsx;
        this.deviceTypeAndroid = builder.deviceTypeAndroid;
        this.deviceTypeIos = builder.deviceTypeIos;
        this.deviceTypeLinux = builder.deviceTypeLinux;
        this.deviceTypeWeb = builder.deviceTypeWeb;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final DefaultImportClientBrandingAttributes deviceTypeWindows() {
        return this.deviceTypeWindows;
    }

    public final DefaultImportClientBrandingAttributes deviceTypeOsx() {
        return this.deviceTypeOsx;
    }

    public final DefaultImportClientBrandingAttributes deviceTypeAndroid() {
        return this.deviceTypeAndroid;
    }

    public final IosImportClientBrandingAttributes deviceTypeIos() {
        return this.deviceTypeIos;
    }

    public final DefaultImportClientBrandingAttributes deviceTypeLinux() {
        return this.deviceTypeLinux;
    }

    public final DefaultImportClientBrandingAttributes deviceTypeWeb() {
        return this.deviceTypeWeb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeWindows());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeOsx());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeAndroid());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeIos());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeLinux());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeWeb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportClientBrandingRequest)) {
            return false;
        }
        ImportClientBrandingRequest other = (ImportClientBrandingRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.deviceTypeWindows(), other.deviceTypeWindows()) && Objects.equals(this.deviceTypeOsx(), other.deviceTypeOsx()) && Objects.equals(this.deviceTypeAndroid(), other.deviceTypeAndroid()) && Objects.equals(this.deviceTypeIos(), other.deviceTypeIos()) && Objects.equals(this.deviceTypeLinux(), other.deviceTypeLinux()) && Objects.equals(this.deviceTypeWeb(), other.deviceTypeWeb());
    }

    public final String toString() {
        return ToString.builder((String)"ImportClientBrandingRequest").add("ResourceId", (Object)this.resourceId()).add("DeviceTypeWindows", (Object)this.deviceTypeWindows()).add("DeviceTypeOsx", (Object)this.deviceTypeOsx()).add("DeviceTypeAndroid", (Object)this.deviceTypeAndroid()).add("DeviceTypeIos", (Object)this.deviceTypeIos()).add("DeviceTypeLinux", (Object)this.deviceTypeLinux()).add("DeviceTypeWeb", (Object)this.deviceTypeWeb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "DeviceTypeWindows": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeWindows()));
            }
            case "DeviceTypeOsx": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeOsx()));
            }
            case "DeviceTypeAndroid": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeAndroid()));
            }
            case "DeviceTypeIos": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeIos()));
            }
            case "DeviceTypeLinux": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeLinux()));
            }
            case "DeviceTypeWeb": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeWeb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportClientBrandingRequest, T> g) {
        return obj -> g.apply((ImportClientBrandingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private DefaultImportClientBrandingAttributes deviceTypeWindows;
        private DefaultImportClientBrandingAttributes deviceTypeOsx;
        private DefaultImportClientBrandingAttributes deviceTypeAndroid;
        private IosImportClientBrandingAttributes deviceTypeIos;
        private DefaultImportClientBrandingAttributes deviceTypeLinux;
        private DefaultImportClientBrandingAttributes deviceTypeWeb;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportClientBrandingRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.deviceTypeWindows(model.deviceTypeWindows);
            this.deviceTypeOsx(model.deviceTypeOsx);
            this.deviceTypeAndroid(model.deviceTypeAndroid);
            this.deviceTypeIos(model.deviceTypeIos);
            this.deviceTypeLinux(model.deviceTypeLinux);
            this.deviceTypeWeb(model.deviceTypeWeb);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeWindows() {
            return this.deviceTypeWindows != null ? this.deviceTypeWindows.toBuilder() : null;
        }

        public final void setDeviceTypeWindows(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows != null ? deviceTypeWindows.build() : null;
        }

        @Override
        public final Builder deviceTypeWindows(DefaultImportClientBrandingAttributes deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeOsx() {
            return this.deviceTypeOsx != null ? this.deviceTypeOsx.toBuilder() : null;
        }

        public final void setDeviceTypeOsx(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx != null ? deviceTypeOsx.build() : null;
        }

        @Override
        public final Builder deviceTypeOsx(DefaultImportClientBrandingAttributes deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeAndroid() {
            return this.deviceTypeAndroid != null ? this.deviceTypeAndroid.toBuilder() : null;
        }

        public final void setDeviceTypeAndroid(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid != null ? deviceTypeAndroid.build() : null;
        }

        @Override
        public final Builder deviceTypeAndroid(DefaultImportClientBrandingAttributes deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid;
            return this;
        }

        public final IosImportClientBrandingAttributes.Builder getDeviceTypeIos() {
            return this.deviceTypeIos != null ? this.deviceTypeIos.toBuilder() : null;
        }

        public final void setDeviceTypeIos(IosImportClientBrandingAttributes.BuilderImpl deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos != null ? deviceTypeIos.build() : null;
        }

        @Override
        public final Builder deviceTypeIos(IosImportClientBrandingAttributes deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeLinux() {
            return this.deviceTypeLinux != null ? this.deviceTypeLinux.toBuilder() : null;
        }

        public final void setDeviceTypeLinux(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux != null ? deviceTypeLinux.build() : null;
        }

        @Override
        public final Builder deviceTypeLinux(DefaultImportClientBrandingAttributes deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeWeb() {
            return this.deviceTypeWeb != null ? this.deviceTypeWeb.toBuilder() : null;
        }

        public final void setDeviceTypeWeb(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb != null ? deviceTypeWeb.build() : null;
        }

        @Override
        public final Builder deviceTypeWeb(DefaultImportClientBrandingAttributes deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportClientBrandingRequest build() {
            return new ImportClientBrandingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportClientBrandingRequest> {
        public Builder resourceId(String var1);

        public Builder deviceTypeWindows(DefaultImportClientBrandingAttributes var1);

        default public Builder deviceTypeWindows(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeWindows) {
            return this.deviceTypeWindows((DefaultImportClientBrandingAttributes)((DefaultImportClientBrandingAttributes.Builder)DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeWindows)).build());
        }

        public Builder deviceTypeOsx(DefaultImportClientBrandingAttributes var1);

        default public Builder deviceTypeOsx(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeOsx) {
            return this.deviceTypeOsx((DefaultImportClientBrandingAttributes)((DefaultImportClientBrandingAttributes.Builder)DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeOsx)).build());
        }

        public Builder deviceTypeAndroid(DefaultImportClientBrandingAttributes var1);

        default public Builder deviceTypeAndroid(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeAndroid) {
            return this.deviceTypeAndroid((DefaultImportClientBrandingAttributes)((DefaultImportClientBrandingAttributes.Builder)DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeAndroid)).build());
        }

        public Builder deviceTypeIos(IosImportClientBrandingAttributes var1);

        default public Builder deviceTypeIos(Consumer<IosImportClientBrandingAttributes.Builder> deviceTypeIos) {
            return this.deviceTypeIos((IosImportClientBrandingAttributes)((IosImportClientBrandingAttributes.Builder)IosImportClientBrandingAttributes.builder().applyMutation(deviceTypeIos)).build());
        }

        public Builder deviceTypeLinux(DefaultImportClientBrandingAttributes var1);

        default public Builder deviceTypeLinux(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeLinux) {
            return this.deviceTypeLinux((DefaultImportClientBrandingAttributes)((DefaultImportClientBrandingAttributes.Builder)DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeLinux)).build());
        }

        public Builder deviceTypeWeb(DefaultImportClientBrandingAttributes var1);

        default public Builder deviceTypeWeb(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeWeb) {
            return this.deviceTypeWeb((DefaultImportClientBrandingAttributes)((DefaultImportClientBrandingAttributes.Builder)DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeWeb)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

