/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ImagePermission;
import software.amazon.awssdk.services.workspaces.model.ImagePermissionsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceImagePermissionsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspaceImagePermissionsResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(DescribeWorkspaceImagePermissionsResponse.getter(DescribeWorkspaceImagePermissionsResponse::imageId)).setter(DescribeWorkspaceImagePermissionsResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<List<ImagePermission>> IMAGE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImagePermissions").getter(DescribeWorkspaceImagePermissionsResponse.getter(DescribeWorkspaceImagePermissionsResponse::imagePermissions)).setter(DescribeWorkspaceImagePermissionsResponse.setter(Builder::imagePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImagePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspaceImagePermissionsResponse.getter(DescribeWorkspaceImagePermissionsResponse::nextToken)).setter(DescribeWorkspaceImagePermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, IMAGE_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkspaceImagePermissionsResponse.memberNameToFieldInitializer();
    private final String imageId;
    private final List<ImagePermission> imagePermissions;
    private final String nextToken;

    private DescribeWorkspaceImagePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.imagePermissions = builder.imagePermissions;
        this.nextToken = builder.nextToken;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final boolean hasImagePermissions() {
        return this.imagePermissions != null && !(this.imagePermissions instanceof SdkAutoConstructList);
    }

    public final List<ImagePermission> imagePermissions() {
        return this.imagePermissions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImagePermissions() ? this.imagePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceImagePermissionsResponse)) {
            return false;
        }
        DescribeWorkspaceImagePermissionsResponse other = (DescribeWorkspaceImagePermissionsResponse)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && this.hasImagePermissions() == other.hasImagePermissions() && Objects.equals(this.imagePermissions(), other.imagePermissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceImagePermissionsResponse").add("ImageId", (Object)this.imageId()).add("ImagePermissions", this.hasImagePermissions() ? this.imagePermissions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ImagePermissions": {
                return Optional.ofNullable(clazz.cast(this.imagePermissions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ImagePermissions", IMAGE_PERMISSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceImagePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceImagePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private String imageId;
        private List<ImagePermission> imagePermissions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceImagePermissionsResponse model) {
            super(model);
            this.imageId(model.imageId);
            this.imagePermissions(model.imagePermissions);
            this.nextToken(model.nextToken);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final List<ImagePermission.Builder> getImagePermissions() {
            List<ImagePermission.Builder> result = ImagePermissionsCopier.copyToBuilder(this.imagePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImagePermissions(Collection<ImagePermission.BuilderImpl> imagePermissions) {
            this.imagePermissions = ImagePermissionsCopier.copyFromBuilder(imagePermissions);
        }

        @Override
        public final Builder imagePermissions(Collection<ImagePermission> imagePermissions) {
            this.imagePermissions = ImagePermissionsCopier.copy(imagePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePermissions(ImagePermission ... imagePermissions) {
            this.imagePermissions(Arrays.asList(imagePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePermissions(Consumer<ImagePermission.Builder> ... imagePermissions) {
            this.imagePermissions(Stream.of(imagePermissions).map(c -> (ImagePermission)((ImagePermission.Builder)ImagePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWorkspaceImagePermissionsResponse build() {
            return new DescribeWorkspaceImagePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceImagePermissionsResponse> {
        public Builder imageId(String var1);

        public Builder imagePermissions(Collection<ImagePermission> var1);

        public Builder imagePermissions(ImagePermission ... var1);

        public Builder imagePermissions(Consumer<ImagePermission.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

