/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ClientDeviceType;
import software.amazon.awssdk.services.workspaces.model.ClientDeviceTypeListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteClientBrandingRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DeleteClientBrandingRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DeleteClientBrandingRequest.getter(DeleteClientBrandingRequest::resourceId)).setter(DeleteClientBrandingRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<List<String>> PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Platforms").getter(DeleteClientBrandingRequest.getter(DeleteClientBrandingRequest::platformsAsStrings)).setter(DeleteClientBrandingRequest.setter(Builder::platformsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, PLATFORMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteClientBrandingRequest.memberNameToFieldInitializer();
    private final String resourceId;
    private final List<String> platforms;

    private DeleteClientBrandingRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.platforms = builder.platforms;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final List<ClientDeviceType> platforms() {
        return ClientDeviceTypeListCopier.copyStringToEnum(this.platforms);
    }

    public final boolean hasPlatforms() {
        return this.platforms != null && !(this.platforms instanceof SdkAutoConstructList);
    }

    public final List<String> platformsAsStrings() {
        return this.platforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatforms() ? this.platformsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClientBrandingRequest)) {
            return false;
        }
        DeleteClientBrandingRequest other = (DeleteClientBrandingRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && this.hasPlatforms() == other.hasPlatforms() && Objects.equals(this.platformsAsStrings(), other.platformsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteClientBrandingRequest").add("ResourceId", (Object)this.resourceId()).add("Platforms", this.hasPlatforms() ? this.platformsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Platforms": {
                return Optional.ofNullable(clazz.cast(this.platformsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Platforms", PLATFORMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteClientBrandingRequest, T> g) {
        return obj -> g.apply((DeleteClientBrandingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private List<String> platforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClientBrandingRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.platformsWithStrings(model.platforms);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Collection<String> getPlatforms() {
            if (this.platforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platforms;
        }

        public final void setPlatforms(Collection<String> platforms) {
            this.platforms = ClientDeviceTypeListCopier.copy(platforms);
        }

        @Override
        public final Builder platformsWithStrings(Collection<String> platforms) {
            this.platforms = ClientDeviceTypeListCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformsWithStrings(String ... platforms) {
            this.platformsWithStrings(Arrays.asList(platforms));
            return this;
        }

        @Override
        public final Builder platforms(Collection<ClientDeviceType> platforms) {
            this.platforms = ClientDeviceTypeListCopier.copyEnumToString(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(ClientDeviceType ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClientBrandingRequest build() {
            return new DeleteClientBrandingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteClientBrandingRequest> {
        public Builder resourceId(String var1);

        public Builder platformsWithStrings(Collection<String> var1);

        public Builder platformsWithStrings(String ... var1);

        public Builder platforms(Collection<ClientDeviceType> var1);

        public Builder platforms(ClientDeviceType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

