/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ApplicationSettingsRequest;
import software.amazon.awssdk.services.workspaces.model.Capacity;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.TimeoutSettings;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspacesPoolRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, CreateWorkspacesPoolRequest> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::poolName)).setter(CreateWorkspacesPoolRequest.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::description)).setter(CreateWorkspacesPoolRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleId").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::bundleId)).setter(CreateWorkspacesPoolRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::directoryId)).setter(CreateWorkspacesPoolRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<Capacity> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capacity").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::capacity)).setter(CreateWorkspacesPoolRequest.setter(Builder::capacity)).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::tags)).setter(CreateWorkspacesPoolRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationSettingsRequest> APPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSettings").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::applicationSettings)).setter(CreateWorkspacesPoolRequest.setter(Builder::applicationSettings)).constructor(ApplicationSettingsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build()}).build();
    private static final SdkField<TimeoutSettings> TIMEOUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeoutSettings").getter(CreateWorkspacesPoolRequest.getter(CreateWorkspacesPoolRequest::timeoutSettings)).setter(CreateWorkspacesPoolRequest.setter(Builder::timeoutSettings)).constructor(TimeoutSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD, DESCRIPTION_FIELD, BUNDLE_ID_FIELD, DIRECTORY_ID_FIELD, CAPACITY_FIELD, TAGS_FIELD, APPLICATION_SETTINGS_FIELD, TIMEOUT_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkspacesPoolRequest.memberNameToFieldInitializer();
    private final String poolName;
    private final String description;
    private final String bundleId;
    private final String directoryId;
    private final Capacity capacity;
    private final List<Tag> tags;
    private final ApplicationSettingsRequest applicationSettings;
    private final TimeoutSettings timeoutSettings;

    private CreateWorkspacesPoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolName = builder.poolName;
        this.description = builder.description;
        this.bundleId = builder.bundleId;
        this.directoryId = builder.directoryId;
        this.capacity = builder.capacity;
        this.tags = builder.tags;
        this.applicationSettings = builder.applicationSettings;
        this.timeoutSettings = builder.timeoutSettings;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final String description() {
        return this.description;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final Capacity capacity() {
        return this.capacity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ApplicationSettingsRequest applicationSettings() {
        return this.applicationSettings;
    }

    public final TimeoutSettings timeoutSettings() {
        return this.timeoutSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesPoolRequest)) {
            return false;
        }
        CreateWorkspacesPoolRequest other = (CreateWorkspacesPoolRequest)((Object)obj);
        return Objects.equals(this.poolName(), other.poolName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.capacity(), other.capacity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.applicationSettings(), other.applicationSettings()) && Objects.equals(this.timeoutSettings(), other.timeoutSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspacesPoolRequest").add("PoolName", (Object)this.poolName()).add("Description", (Object)this.description()).add("BundleId", (Object)this.bundleId()).add("DirectoryId", (Object)this.directoryId()).add("Capacity", (Object)this.capacity()).add("Tags", this.hasTags() ? this.tags() : null).add("ApplicationSettings", (Object)this.applicationSettings()).add("TimeoutSettings", (Object)this.timeoutSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
            case "TimeoutSettings": {
                return Optional.ofNullable(clazz.cast(this.timeoutSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BundleId", BUNDLE_ID_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ApplicationSettings", APPLICATION_SETTINGS_FIELD);
        map.put("TimeoutSettings", TIMEOUT_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspacesPoolRequest, T> g) {
        return obj -> g.apply((CreateWorkspacesPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String poolName;
        private String description;
        private String bundleId;
        private String directoryId;
        private Capacity capacity;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ApplicationSettingsRequest applicationSettings;
        private TimeoutSettings timeoutSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspacesPoolRequest model) {
            super(model);
            this.poolName(model.poolName);
            this.description(model.description);
            this.bundleId(model.bundleId);
            this.directoryId(model.directoryId);
            this.capacity(model.capacity);
            this.tags(model.tags);
            this.applicationSettings(model.applicationSettings);
            this.timeoutSettings(model.timeoutSettings);
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Capacity.Builder getCapacity() {
            return this.capacity != null ? this.capacity.toBuilder() : null;
        }

        public final void setCapacity(Capacity.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApplicationSettingsRequest.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettingsRequest.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsRequest applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final TimeoutSettings.Builder getTimeoutSettings() {
            return this.timeoutSettings != null ? this.timeoutSettings.toBuilder() : null;
        }

        public final void setTimeoutSettings(TimeoutSettings.BuilderImpl timeoutSettings) {
            this.timeoutSettings = timeoutSettings != null ? timeoutSettings.build() : null;
        }

        @Override
        public final Builder timeoutSettings(TimeoutSettings timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspacesPoolRequest build() {
            return new CreateWorkspacesPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspacesPoolRequest> {
        public Builder poolName(String var1);

        public Builder description(String var1);

        public Builder bundleId(String var1);

        public Builder directoryId(String var1);

        public Builder capacity(Capacity var1);

        default public Builder capacity(Consumer<Capacity.Builder> capacity) {
            return this.capacity((Capacity)((Capacity.Builder)Capacity.builder().applyMutation(capacity)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder applicationSettings(ApplicationSettingsRequest var1);

        default public Builder applicationSettings(Consumer<ApplicationSettingsRequest.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettingsRequest)((ApplicationSettingsRequest.Builder)ApplicationSettingsRequest.builder().applyMutation(applicationSettings)).build());
        }

        public Builder timeoutSettings(TimeoutSettings var1);

        default public Builder timeoutSettings(Consumer<TimeoutSettings.Builder> timeoutSettings) {
            return this.timeoutSettings((TimeoutSettings)((TimeoutSettings.Builder)TimeoutSettings.builder().applyMutation(timeoutSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

