/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyWorkspaceCreationPropertiesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyWorkspaceCreationPropertiesRequest.Builder, ModifyWorkspaceCreationPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ModifyWorkspaceCreationPropertiesRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<WorkspaceCreationProperties> WORKSPACE_CREATION_PROPERTIES_FIELD = SdkField
            .<WorkspaceCreationProperties> builder(MarshallingType.SDK_POJO)
            .memberName("WorkspaceCreationProperties")
            .getter(getter(ModifyWorkspaceCreationPropertiesRequest::workspaceCreationProperties))
            .setter(setter(Builder::workspaceCreationProperties))
            .constructor(WorkspaceCreationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceCreationProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            WORKSPACE_CREATION_PROPERTIES_FIELD));

    private final String resourceId;

    private final WorkspaceCreationProperties workspaceCreationProperties;

    private ModifyWorkspaceCreationPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.workspaceCreationProperties = builder.workspaceCreationProperties;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The default properties for creating WorkSpaces.
     * </p>
     * 
     * @return The default properties for creating WorkSpaces.
     */
    public final WorkspaceCreationProperties workspaceCreationProperties() {
        return workspaceCreationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceCreationProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyWorkspaceCreationPropertiesRequest)) {
            return false;
        }
        ModifyWorkspaceCreationPropertiesRequest other = (ModifyWorkspaceCreationPropertiesRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(workspaceCreationProperties(), other.workspaceCreationProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyWorkspaceCreationPropertiesRequest").add("ResourceId", resourceId())
                .add("WorkspaceCreationProperties", workspaceCreationProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "WorkspaceCreationProperties":
            return Optional.ofNullable(clazz.cast(workspaceCreationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyWorkspaceCreationPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyWorkspaceCreationPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyWorkspaceCreationPropertiesRequest> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The default properties for creating WorkSpaces.
         * </p>
         * 
         * @param workspaceCreationProperties
         *        The default properties for creating WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceCreationProperties(WorkspaceCreationProperties workspaceCreationProperties);

        /**
         * <p>
         * The default properties for creating WorkSpaces.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceCreationProperties.Builder}
         * avoiding the need to create one manually via {@link WorkspaceCreationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceCreationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #workspaceCreationProperties(WorkspaceCreationProperties)}.
         * 
         * @param workspaceCreationProperties
         *        a consumer that will call methods on {@link WorkspaceCreationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceCreationProperties(WorkspaceCreationProperties)
         */
        default Builder workspaceCreationProperties(Consumer<WorkspaceCreationProperties.Builder> workspaceCreationProperties) {
            return workspaceCreationProperties(WorkspaceCreationProperties.builder().applyMutation(workspaceCreationProperties)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private WorkspaceCreationProperties workspaceCreationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyWorkspaceCreationPropertiesRequest model) {
            super(model);
            resourceId(model.resourceId);
            workspaceCreationProperties(model.workspaceCreationProperties);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final WorkspaceCreationProperties.Builder getWorkspaceCreationProperties() {
            return workspaceCreationProperties != null ? workspaceCreationProperties.toBuilder() : null;
        }

        public final void setWorkspaceCreationProperties(WorkspaceCreationProperties.BuilderImpl workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties != null ? workspaceCreationProperties.build() : null;
        }

        @Override
        public final Builder workspaceCreationProperties(WorkspaceCreationProperties workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyWorkspaceCreationPropertiesRequest build() {
            return new ModifyWorkspaceCreationPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
