/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySelfservicePermissionsRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifySelfservicePermissionsRequest.Builder, ModifySelfservicePermissionsRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ModifySelfservicePermissionsRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<SelfservicePermissions> SELFSERVICE_PERMISSIONS_FIELD = SdkField
            .<SelfservicePermissions> builder(MarshallingType.SDK_POJO).memberName("SelfservicePermissions")
            .getter(getter(ModifySelfservicePermissionsRequest::selfservicePermissions))
            .setter(setter(Builder::selfservicePermissions)).constructor(SelfservicePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfservicePermissions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            SELFSERVICE_PERMISSIONS_FIELD));

    private final String resourceId;

    private final SelfservicePermissions selfservicePermissions;

    private ModifySelfservicePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.selfservicePermissions = builder.selfservicePermissions;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The permissions to enable or disable self-service capabilities.
     * </p>
     * 
     * @return The permissions to enable or disable self-service capabilities.
     */
    public final SelfservicePermissions selfservicePermissions() {
        return selfservicePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(selfservicePermissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySelfservicePermissionsRequest)) {
            return false;
        }
        ModifySelfservicePermissionsRequest other = (ModifySelfservicePermissionsRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(selfservicePermissions(), other.selfservicePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySelfservicePermissionsRequest").add("ResourceId", resourceId())
                .add("SelfservicePermissions", selfservicePermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "SelfservicePermissions":
            return Optional.ofNullable(clazz.cast(selfservicePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySelfservicePermissionsRequest, T> g) {
        return obj -> g.apply((ModifySelfservicePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifySelfservicePermissionsRequest> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The permissions to enable or disable self-service capabilities.
         * </p>
         * 
         * @param selfservicePermissions
         *        The permissions to enable or disable self-service capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfservicePermissions(SelfservicePermissions selfservicePermissions);

        /**
         * <p>
         * The permissions to enable or disable self-service capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelfservicePermissions.Builder} avoiding
         * the need to create one manually via {@link SelfservicePermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfservicePermissions.Builder#build()} is called immediately and
         * its result is passed to {@link #selfservicePermissions(SelfservicePermissions)}.
         * 
         * @param selfservicePermissions
         *        a consumer that will call methods on {@link SelfservicePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfservicePermissions(SelfservicePermissions)
         */
        default Builder selfservicePermissions(Consumer<SelfservicePermissions.Builder> selfservicePermissions) {
            return selfservicePermissions(SelfservicePermissions.builder().applyMutation(selfservicePermissions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private SelfservicePermissions selfservicePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySelfservicePermissionsRequest model) {
            super(model);
            resourceId(model.resourceId);
            selfservicePermissions(model.selfservicePermissions);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SelfservicePermissions.Builder getSelfservicePermissions() {
            return selfservicePermissions != null ? selfservicePermissions.toBuilder() : null;
        }

        public final void setSelfservicePermissions(SelfservicePermissions.BuilderImpl selfservicePermissions) {
            this.selfservicePermissions = selfservicePermissions != null ? selfservicePermissions.build() : null;
        }

        @Override
        public final Builder selfservicePermissions(SelfservicePermissions selfservicePermissions) {
            this.selfservicePermissions = selfservicePermissions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySelfservicePermissionsRequest build() {
            return new ModifySelfservicePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
