/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClientBrandingResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeClientBrandingResponse.Builder, DescribeClientBrandingResponse> {
    private static final SdkField<DefaultClientBrandingAttributes> DEVICE_TYPE_WINDOWS_FIELD = SdkField
            .<DefaultClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeWindows")
            .getter(getter(DescribeClientBrandingResponse::deviceTypeWindows)).setter(setter(Builder::deviceTypeWindows))
            .constructor(DefaultClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWindows").build()).build();

    private static final SdkField<DefaultClientBrandingAttributes> DEVICE_TYPE_OSX_FIELD = SdkField
            .<DefaultClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeOsx")
            .getter(getter(DescribeClientBrandingResponse::deviceTypeOsx)).setter(setter(Builder::deviceTypeOsx))
            .constructor(DefaultClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeOsx").build()).build();

    private static final SdkField<DefaultClientBrandingAttributes> DEVICE_TYPE_ANDROID_FIELD = SdkField
            .<DefaultClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeAndroid")
            .getter(getter(DescribeClientBrandingResponse::deviceTypeAndroid)).setter(setter(Builder::deviceTypeAndroid))
            .constructor(DefaultClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeAndroid").build()).build();

    private static final SdkField<IosClientBrandingAttributes> DEVICE_TYPE_IOS_FIELD = SdkField
            .<IosClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeIos")
            .getter(getter(DescribeClientBrandingResponse::deviceTypeIos)).setter(setter(Builder::deviceTypeIos))
            .constructor(IosClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeIos").build()).build();

    private static final SdkField<DefaultClientBrandingAttributes> DEVICE_TYPE_LINUX_FIELD = SdkField
            .<DefaultClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeLinux")
            .getter(getter(DescribeClientBrandingResponse::deviceTypeLinux)).setter(setter(Builder::deviceTypeLinux))
            .constructor(DefaultClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeLinux").build()).build();

    private static final SdkField<DefaultClientBrandingAttributes> DEVICE_TYPE_WEB_FIELD = SdkField
            .<DefaultClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeWeb")
            .getter(getter(DescribeClientBrandingResponse::deviceTypeWeb)).setter(setter(Builder::deviceTypeWeb))
            .constructor(DefaultClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWeb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TYPE_WINDOWS_FIELD,
            DEVICE_TYPE_OSX_FIELD, DEVICE_TYPE_ANDROID_FIELD, DEVICE_TYPE_IOS_FIELD, DEVICE_TYPE_LINUX_FIELD,
            DEVICE_TYPE_WEB_FIELD));

    private final DefaultClientBrandingAttributes deviceTypeWindows;

    private final DefaultClientBrandingAttributes deviceTypeOsx;

    private final DefaultClientBrandingAttributes deviceTypeAndroid;

    private final IosClientBrandingAttributes deviceTypeIos;

    private final DefaultClientBrandingAttributes deviceTypeLinux;

    private final DefaultClientBrandingAttributes deviceTypeWeb;

    private DescribeClientBrandingResponse(BuilderImpl builder) {
        super(builder);
        this.deviceTypeWindows = builder.deviceTypeWindows;
        this.deviceTypeOsx = builder.deviceTypeOsx;
        this.deviceTypeAndroid = builder.deviceTypeAndroid;
        this.deviceTypeIos = builder.deviceTypeIos;
        this.deviceTypeLinux = builder.deviceTypeLinux;
        this.deviceTypeWeb = builder.deviceTypeWeb;
    }

    /**
     * <p>
     * The branding information for Windows devices.
     * </p>
     * 
     * @return The branding information for Windows devices.
     */
    public final DefaultClientBrandingAttributes deviceTypeWindows() {
        return deviceTypeWindows;
    }

    /**
     * <p>
     * The branding information for macOS devices.
     * </p>
     * 
     * @return The branding information for macOS devices.
     */
    public final DefaultClientBrandingAttributes deviceTypeOsx() {
        return deviceTypeOsx;
    }

    /**
     * <p>
     * The branding information for Android devices.
     * </p>
     * 
     * @return The branding information for Android devices.
     */
    public final DefaultClientBrandingAttributes deviceTypeAndroid() {
        return deviceTypeAndroid;
    }

    /**
     * <p>
     * The branding information for iOS devices.
     * </p>
     * 
     * @return The branding information for iOS devices.
     */
    public final IosClientBrandingAttributes deviceTypeIos() {
        return deviceTypeIos;
    }

    /**
     * <p>
     * The branding information for Linux devices.
     * </p>
     * 
     * @return The branding information for Linux devices.
     */
    public final DefaultClientBrandingAttributes deviceTypeLinux() {
        return deviceTypeLinux;
    }

    /**
     * <p>
     * The branding information for Web access.
     * </p>
     * 
     * @return The branding information for Web access.
     */
    public final DefaultClientBrandingAttributes deviceTypeWeb() {
        return deviceTypeWeb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeWindows());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeOsx());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeAndroid());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeIos());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeLinux());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeWeb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientBrandingResponse)) {
            return false;
        }
        DescribeClientBrandingResponse other = (DescribeClientBrandingResponse) obj;
        return Objects.equals(deviceTypeWindows(), other.deviceTypeWindows())
                && Objects.equals(deviceTypeOsx(), other.deviceTypeOsx())
                && Objects.equals(deviceTypeAndroid(), other.deviceTypeAndroid())
                && Objects.equals(deviceTypeIos(), other.deviceTypeIos())
                && Objects.equals(deviceTypeLinux(), other.deviceTypeLinux())
                && Objects.equals(deviceTypeWeb(), other.deviceTypeWeb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClientBrandingResponse").add("DeviceTypeWindows", deviceTypeWindows())
                .add("DeviceTypeOsx", deviceTypeOsx()).add("DeviceTypeAndroid", deviceTypeAndroid())
                .add("DeviceTypeIos", deviceTypeIos()).add("DeviceTypeLinux", deviceTypeLinux())
                .add("DeviceTypeWeb", deviceTypeWeb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceTypeWindows":
            return Optional.ofNullable(clazz.cast(deviceTypeWindows()));
        case "DeviceTypeOsx":
            return Optional.ofNullable(clazz.cast(deviceTypeOsx()));
        case "DeviceTypeAndroid":
            return Optional.ofNullable(clazz.cast(deviceTypeAndroid()));
        case "DeviceTypeIos":
            return Optional.ofNullable(clazz.cast(deviceTypeIos()));
        case "DeviceTypeLinux":
            return Optional.ofNullable(clazz.cast(deviceTypeLinux()));
        case "DeviceTypeWeb":
            return Optional.ofNullable(clazz.cast(deviceTypeWeb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientBrandingResponse, T> g) {
        return obj -> g.apply((DescribeClientBrandingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClientBrandingResponse> {
        /**
         * <p>
         * The branding information for Windows devices.
         * </p>
         * 
         * @param deviceTypeWindows
         *        The branding information for Windows devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeWindows(DefaultClientBrandingAttributes deviceTypeWindows);

        /**
         * <p>
         * The branding information for Windows devices.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultClientBrandingAttributes.Builder}
         * avoiding the need to create one manually via {@link DefaultClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeWindows(DefaultClientBrandingAttributes)}.
         * 
         * @param deviceTypeWindows
         *        a consumer that will call methods on {@link DefaultClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeWindows(DefaultClientBrandingAttributes)
         */
        default Builder deviceTypeWindows(Consumer<DefaultClientBrandingAttributes.Builder> deviceTypeWindows) {
            return deviceTypeWindows(DefaultClientBrandingAttributes.builder().applyMutation(deviceTypeWindows).build());
        }

        /**
         * <p>
         * The branding information for macOS devices.
         * </p>
         * 
         * @param deviceTypeOsx
         *        The branding information for macOS devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeOsx(DefaultClientBrandingAttributes deviceTypeOsx);

        /**
         * <p>
         * The branding information for macOS devices.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultClientBrandingAttributes.Builder}
         * avoiding the need to create one manually via {@link DefaultClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeOsx(DefaultClientBrandingAttributes)}.
         * 
         * @param deviceTypeOsx
         *        a consumer that will call methods on {@link DefaultClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeOsx(DefaultClientBrandingAttributes)
         */
        default Builder deviceTypeOsx(Consumer<DefaultClientBrandingAttributes.Builder> deviceTypeOsx) {
            return deviceTypeOsx(DefaultClientBrandingAttributes.builder().applyMutation(deviceTypeOsx).build());
        }

        /**
         * <p>
         * The branding information for Android devices.
         * </p>
         * 
         * @param deviceTypeAndroid
         *        The branding information for Android devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeAndroid(DefaultClientBrandingAttributes deviceTypeAndroid);

        /**
         * <p>
         * The branding information for Android devices.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultClientBrandingAttributes.Builder}
         * avoiding the need to create one manually via {@link DefaultClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeAndroid(DefaultClientBrandingAttributes)}.
         * 
         * @param deviceTypeAndroid
         *        a consumer that will call methods on {@link DefaultClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeAndroid(DefaultClientBrandingAttributes)
         */
        default Builder deviceTypeAndroid(Consumer<DefaultClientBrandingAttributes.Builder> deviceTypeAndroid) {
            return deviceTypeAndroid(DefaultClientBrandingAttributes.builder().applyMutation(deviceTypeAndroid).build());
        }

        /**
         * <p>
         * The branding information for iOS devices.
         * </p>
         * 
         * @param deviceTypeIos
         *        The branding information for iOS devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeIos(IosClientBrandingAttributes deviceTypeIos);

        /**
         * <p>
         * The branding information for iOS devices.
         * </p>
         * This is a convenience method that creates an instance of the {@link IosClientBrandingAttributes.Builder}
         * avoiding the need to create one manually via {@link IosClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IosClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeIos(IosClientBrandingAttributes)}.
         * 
         * @param deviceTypeIos
         *        a consumer that will call methods on {@link IosClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeIos(IosClientBrandingAttributes)
         */
        default Builder deviceTypeIos(Consumer<IosClientBrandingAttributes.Builder> deviceTypeIos) {
            return deviceTypeIos(IosClientBrandingAttributes.builder().applyMutation(deviceTypeIos).build());
        }

        /**
         * <p>
         * The branding information for Linux devices.
         * </p>
         * 
         * @param deviceTypeLinux
         *        The branding information for Linux devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeLinux(DefaultClientBrandingAttributes deviceTypeLinux);

        /**
         * <p>
         * The branding information for Linux devices.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultClientBrandingAttributes.Builder}
         * avoiding the need to create one manually via {@link DefaultClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeLinux(DefaultClientBrandingAttributes)}.
         * 
         * @param deviceTypeLinux
         *        a consumer that will call methods on {@link DefaultClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeLinux(DefaultClientBrandingAttributes)
         */
        default Builder deviceTypeLinux(Consumer<DefaultClientBrandingAttributes.Builder> deviceTypeLinux) {
            return deviceTypeLinux(DefaultClientBrandingAttributes.builder().applyMutation(deviceTypeLinux).build());
        }

        /**
         * <p>
         * The branding information for Web access.
         * </p>
         * 
         * @param deviceTypeWeb
         *        The branding information for Web access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeWeb(DefaultClientBrandingAttributes deviceTypeWeb);

        /**
         * <p>
         * The branding information for Web access.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultClientBrandingAttributes.Builder}
         * avoiding the need to create one manually via {@link DefaultClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeWeb(DefaultClientBrandingAttributes)}.
         * 
         * @param deviceTypeWeb
         *        a consumer that will call methods on {@link DefaultClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeWeb(DefaultClientBrandingAttributes)
         */
        default Builder deviceTypeWeb(Consumer<DefaultClientBrandingAttributes.Builder> deviceTypeWeb) {
            return deviceTypeWeb(DefaultClientBrandingAttributes.builder().applyMutation(deviceTypeWeb).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private DefaultClientBrandingAttributes deviceTypeWindows;

        private DefaultClientBrandingAttributes deviceTypeOsx;

        private DefaultClientBrandingAttributes deviceTypeAndroid;

        private IosClientBrandingAttributes deviceTypeIos;

        private DefaultClientBrandingAttributes deviceTypeLinux;

        private DefaultClientBrandingAttributes deviceTypeWeb;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientBrandingResponse model) {
            super(model);
            deviceTypeWindows(model.deviceTypeWindows);
            deviceTypeOsx(model.deviceTypeOsx);
            deviceTypeAndroid(model.deviceTypeAndroid);
            deviceTypeIos(model.deviceTypeIos);
            deviceTypeLinux(model.deviceTypeLinux);
            deviceTypeWeb(model.deviceTypeWeb);
        }

        public final DefaultClientBrandingAttributes.Builder getDeviceTypeWindows() {
            return deviceTypeWindows != null ? deviceTypeWindows.toBuilder() : null;
        }

        public final void setDeviceTypeWindows(DefaultClientBrandingAttributes.BuilderImpl deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows != null ? deviceTypeWindows.build() : null;
        }

        @Override
        public final Builder deviceTypeWindows(DefaultClientBrandingAttributes deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows;
            return this;
        }

        public final DefaultClientBrandingAttributes.Builder getDeviceTypeOsx() {
            return deviceTypeOsx != null ? deviceTypeOsx.toBuilder() : null;
        }

        public final void setDeviceTypeOsx(DefaultClientBrandingAttributes.BuilderImpl deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx != null ? deviceTypeOsx.build() : null;
        }

        @Override
        public final Builder deviceTypeOsx(DefaultClientBrandingAttributes deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx;
            return this;
        }

        public final DefaultClientBrandingAttributes.Builder getDeviceTypeAndroid() {
            return deviceTypeAndroid != null ? deviceTypeAndroid.toBuilder() : null;
        }

        public final void setDeviceTypeAndroid(DefaultClientBrandingAttributes.BuilderImpl deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid != null ? deviceTypeAndroid.build() : null;
        }

        @Override
        public final Builder deviceTypeAndroid(DefaultClientBrandingAttributes deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid;
            return this;
        }

        public final IosClientBrandingAttributes.Builder getDeviceTypeIos() {
            return deviceTypeIos != null ? deviceTypeIos.toBuilder() : null;
        }

        public final void setDeviceTypeIos(IosClientBrandingAttributes.BuilderImpl deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos != null ? deviceTypeIos.build() : null;
        }

        @Override
        public final Builder deviceTypeIos(IosClientBrandingAttributes deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos;
            return this;
        }

        public final DefaultClientBrandingAttributes.Builder getDeviceTypeLinux() {
            return deviceTypeLinux != null ? deviceTypeLinux.toBuilder() : null;
        }

        public final void setDeviceTypeLinux(DefaultClientBrandingAttributes.BuilderImpl deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux != null ? deviceTypeLinux.build() : null;
        }

        @Override
        public final Builder deviceTypeLinux(DefaultClientBrandingAttributes deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux;
            return this;
        }

        public final DefaultClientBrandingAttributes.Builder getDeviceTypeWeb() {
            return deviceTypeWeb != null ? deviceTypeWeb.toBuilder() : null;
        }

        public final void setDeviceTypeWeb(DefaultClientBrandingAttributes.BuilderImpl deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb != null ? deviceTypeWeb.build() : null;
        }

        @Override
        public final Builder deviceTypeWeb(DefaultClientBrandingAttributes deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb;
            return this;
        }

        @Override
        public DescribeClientBrandingResponse build() {
            return new DescribeClientBrandingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
