/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkspaceState {
    PENDING("PENDING"),
    AVAILABLE("AVAILABLE"),
    IMPAIRED("IMPAIRED"),
    UNHEALTHY("UNHEALTHY"),
    REBOOTING("REBOOTING"),
    STARTING("STARTING"),
    REBUILDING("REBUILDING"),
    RESTORING("RESTORING"),
    MAINTENANCE("MAINTENANCE"),
    ADMIN_MAINTENANCE("ADMIN_MAINTENANCE"),
    TERMINATING("TERMINATING"),
    TERMINATED("TERMINATED"),
    SUSPENDED("SUSPENDED"),
    UPDATING("UPDATING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspaceState> VALUE_MAP;
    private final String value;

    private WorkspaceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkspaceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkspaceState> knownValues() {
        EnumSet<WorkspaceState> knownValues = EnumSet.allOf(WorkspaceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkspaceState.class, WorkspaceState::toString);
    }
}

