/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.ComputeType;
import software.amazon.awssdk.services.workspaces.model.RootStorage;
import software.amazon.awssdk.services.workspaces.model.UserStorage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceBundle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceBundle> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleId").getter(WorkspaceBundle.getter(WorkspaceBundle::bundleId)).setter(WorkspaceBundle.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WorkspaceBundle.getter(WorkspaceBundle::name)).setter(WorkspaceBundle.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(WorkspaceBundle.getter(WorkspaceBundle::owner)).setter(WorkspaceBundle.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(WorkspaceBundle.getter(WorkspaceBundle::description)).setter(WorkspaceBundle.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(WorkspaceBundle.getter(WorkspaceBundle::imageId)).setter(WorkspaceBundle.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<RootStorage> ROOT_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootStorage").getter(WorkspaceBundle.getter(WorkspaceBundle::rootStorage)).setter(WorkspaceBundle.setter(Builder::rootStorage)).constructor(RootStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootStorage").build()}).build();
    private static final SdkField<UserStorage> USER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserStorage").getter(WorkspaceBundle.getter(WorkspaceBundle::userStorage)).setter(WorkspaceBundle.setter(Builder::userStorage)).constructor(UserStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStorage").build()}).build();
    private static final SdkField<ComputeType> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeType").getter(WorkspaceBundle.getter(WorkspaceBundle::computeType)).setter(WorkspaceBundle.setter(Builder::computeType)).constructor(ComputeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(WorkspaceBundle.getter(WorkspaceBundle::lastUpdatedTime)).setter(WorkspaceBundle.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(WorkspaceBundle.getter(WorkspaceBundle::creationTime)).setter(WorkspaceBundle.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, NAME_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, IMAGE_ID_FIELD, ROOT_STORAGE_FIELD, USER_STORAGE_FIELD, COMPUTE_TYPE_FIELD, LAST_UPDATED_TIME_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bundleId;
    private final String name;
    private final String owner;
    private final String description;
    private final String imageId;
    private final RootStorage rootStorage;
    private final UserStorage userStorage;
    private final ComputeType computeType;
    private final Instant lastUpdatedTime;
    private final Instant creationTime;

    private WorkspaceBundle(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.imageId = builder.imageId;
        this.rootStorage = builder.rootStorage;
        this.userStorage = builder.userStorage;
        this.computeType = builder.computeType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.creationTime = builder.creationTime;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final String description() {
        return this.description;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final RootStorage rootStorage() {
        return this.rootStorage;
    }

    public final UserStorage userStorage() {
        return this.userStorage;
    }

    public final ComputeType computeType() {
        return this.computeType;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.userStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceBundle)) {
            return false;
        }
        WorkspaceBundle other = (WorkspaceBundle)obj;
        return Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.rootStorage(), other.rootStorage()) && Objects.equals(this.userStorage(), other.userStorage()) && Objects.equals(this.computeType(), other.computeType()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceBundle").add("BundleId", (Object)this.bundleId()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("Description", (Object)this.description()).add("ImageId", (Object)this.imageId()).add("RootStorage", (Object)this.rootStorage()).add("UserStorage", (Object)this.userStorage()).add("ComputeType", (Object)this.computeType()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "RootStorage": {
                return Optional.ofNullable(clazz.cast(this.rootStorage()));
            }
            case "UserStorage": {
                return Optional.ofNullable(clazz.cast(this.userStorage()));
            }
            case "ComputeType": {
                return Optional.ofNullable(clazz.cast(this.computeType()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceBundle, T> g) {
        return obj -> g.apply((WorkspaceBundle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bundleId;
        private String name;
        private String owner;
        private String description;
        private String imageId;
        private RootStorage rootStorage;
        private UserStorage userStorage;
        private ComputeType computeType;
        private Instant lastUpdatedTime;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceBundle model) {
            this.bundleId(model.bundleId);
            this.name(model.name);
            this.owner(model.owner);
            this.description(model.description);
            this.imageId(model.imageId);
            this.rootStorage(model.rootStorage);
            this.userStorage(model.userStorage);
            this.computeType(model.computeType);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.creationTime(model.creationTime);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final RootStorage.Builder getRootStorage() {
            return this.rootStorage != null ? this.rootStorage.toBuilder() : null;
        }

        @Override
        public final Builder rootStorage(RootStorage rootStorage) {
            this.rootStorage = rootStorage;
            return this;
        }

        public final void setRootStorage(RootStorage.BuilderImpl rootStorage) {
            this.rootStorage = rootStorage != null ? rootStorage.build() : null;
        }

        public final UserStorage.Builder getUserStorage() {
            return this.userStorage != null ? this.userStorage.toBuilder() : null;
        }

        @Override
        public final Builder userStorage(UserStorage userStorage) {
            this.userStorage = userStorage;
            return this;
        }

        public final void setUserStorage(UserStorage.BuilderImpl userStorage) {
            this.userStorage = userStorage != null ? userStorage.build() : null;
        }

        public final ComputeType.Builder getComputeType() {
            return this.computeType != null ? this.computeType.toBuilder() : null;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType = computeType;
            return this;
        }

        public final void setComputeType(ComputeType.BuilderImpl computeType) {
            this.computeType = computeType != null ? computeType.build() : null;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public WorkspaceBundle build() {
            return new WorkspaceBundle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceBundle> {
        public Builder bundleId(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder imageId(String var1);

        public Builder rootStorage(RootStorage var1);

        default public Builder rootStorage(Consumer<RootStorage.Builder> rootStorage) {
            return this.rootStorage((RootStorage)((RootStorage.Builder)RootStorage.builder().applyMutation(rootStorage)).build());
        }

        public Builder userStorage(UserStorage var1);

        default public Builder userStorage(Consumer<UserStorage.Builder> userStorage) {
            return this.userStorage((UserStorage)((UserStorage.Builder)UserStorage.builder().applyMutation(userStorage)).build());
        }

        public Builder computeType(ComputeType var1);

        default public Builder computeType(Consumer<ComputeType.Builder> computeType) {
            return this.computeType((ComputeType)((ComputeType.Builder)ComputeType.builder().applyMutation(computeType)).build());
        }

        public Builder lastUpdatedTime(Instant var1);

        public Builder creationTime(Instant var1);
    }
}

