/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory;

public class DescribeWorkspaceDirectoriesPublisher
implements SdkPublisher<DescribeWorkspaceDirectoriesResponse> {
    private final WorkSpacesAsyncClient client;
    private final DescribeWorkspaceDirectoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeWorkspaceDirectoriesPublisher(WorkSpacesAsyncClient client, DescribeWorkspaceDirectoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeWorkspaceDirectoriesPublisher(WorkSpacesAsyncClient client, DescribeWorkspaceDirectoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeWorkspaceDirectoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeWorkspaceDirectoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkspaceDirectory> directories() {
        Function<DescribeWorkspaceDirectoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.directories() != null) {
                return response.directories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeWorkspaceDirectoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeWorkspaceDirectoriesResponseFetcher
    implements AsyncPageFetcher<DescribeWorkspaceDirectoriesResponse> {
        private DescribeWorkspaceDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWorkspaceDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeWorkspaceDirectoriesResponse> nextPage(DescribeWorkspaceDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeWorkspaceDirectoriesPublisher.this.client.describeWorkspaceDirectories(DescribeWorkspaceDirectoriesPublisher.this.firstRequest);
            }
            return DescribeWorkspaceDirectoriesPublisher.this.client.describeWorkspaceDirectories((DescribeWorkspaceDirectoriesRequest)((Object)DescribeWorkspaceDirectoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

