/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspaceImagePermissionRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, UpdateWorkspaceImagePermissionRequest> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(UpdateWorkspaceImagePermissionRequest.getter(UpdateWorkspaceImagePermissionRequest::imageId)).setter(UpdateWorkspaceImagePermissionRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<Boolean> ALLOW_COPY_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowCopyImage").getter(UpdateWorkspaceImagePermissionRequest.getter(UpdateWorkspaceImagePermissionRequest::allowCopyImage)).setter(UpdateWorkspaceImagePermissionRequest.setter(Builder::allowCopyImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCopyImage").build()}).build();
    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedAccountId").getter(UpdateWorkspaceImagePermissionRequest.getter(UpdateWorkspaceImagePermissionRequest::sharedAccountId)).setter(UpdateWorkspaceImagePermissionRequest.setter(Builder::sharedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, ALLOW_COPY_IMAGE_FIELD, SHARED_ACCOUNT_ID_FIELD));
    private final String imageId;
    private final Boolean allowCopyImage;
    private final String sharedAccountId;

    private UpdateWorkspaceImagePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.allowCopyImage = builder.allowCopyImage;
        this.sharedAccountId = builder.sharedAccountId;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final Boolean allowCopyImage() {
        return this.allowCopyImage;
    }

    public final String sharedAccountId() {
        return this.sharedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowCopyImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceImagePermissionRequest)) {
            return false;
        }
        UpdateWorkspaceImagePermissionRequest other = (UpdateWorkspaceImagePermissionRequest)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.allowCopyImage(), other.allowCopyImage()) && Objects.equals(this.sharedAccountId(), other.sharedAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspaceImagePermissionRequest").add("ImageId", (Object)this.imageId()).add("AllowCopyImage", (Object)this.allowCopyImage()).add("SharedAccountId", (Object)this.sharedAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "AllowCopyImage": {
                return Optional.ofNullable(clazz.cast(this.allowCopyImage()));
            }
            case "SharedAccountId": {
                return Optional.ofNullable(clazz.cast(this.sharedAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceImagePermissionRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceImagePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String imageId;
        private Boolean allowCopyImage;
        private String sharedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceImagePermissionRequest model) {
            super(model);
            this.imageId(model.imageId);
            this.allowCopyImage(model.allowCopyImage);
            this.sharedAccountId(model.sharedAccountId);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Boolean getAllowCopyImage() {
            return this.allowCopyImage;
        }

        @Override
        public final Builder allowCopyImage(Boolean allowCopyImage) {
            this.allowCopyImage = allowCopyImage;
            return this;
        }

        public final void setAllowCopyImage(Boolean allowCopyImage) {
            this.allowCopyImage = allowCopyImage;
        }

        public final String getSharedAccountId() {
            return this.sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceImagePermissionRequest build() {
            return new UpdateWorkspaceImagePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspaceImagePermissionRequest> {
        public Builder imageId(String var1);

        public Builder allowCopyImage(Boolean var1);

        public Builder sharedAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

