/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus;
import software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesConnectionStatusResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspacesConnectionStatusResponse> {
    private static final SdkField<List<WorkspaceConnectionStatus>> WORKSPACES_CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspacesConnectionStatus").getter(DescribeWorkspacesConnectionStatusResponse.getter(DescribeWorkspacesConnectionStatusResponse::workspacesConnectionStatus)).setter(DescribeWorkspacesConnectionStatusResponse.setter(Builder::workspacesConnectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspacesConnectionStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspacesConnectionStatusResponse.getter(DescribeWorkspacesConnectionStatusResponse::nextToken)).setter(DescribeWorkspacesConnectionStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACES_CONNECTION_STATUS_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorkspaceConnectionStatus> workspacesConnectionStatus;
    private final String nextToken;

    private DescribeWorkspacesConnectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.workspacesConnectionStatus = builder.workspacesConnectionStatus;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkspacesConnectionStatus() {
        return this.workspacesConnectionStatus != null && !(this.workspacesConnectionStatus instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceConnectionStatus> workspacesConnectionStatus() {
        return this.workspacesConnectionStatus;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspacesConnectionStatus() ? this.workspacesConnectionStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesConnectionStatusResponse)) {
            return false;
        }
        DescribeWorkspacesConnectionStatusResponse other = (DescribeWorkspacesConnectionStatusResponse)((Object)obj);
        return this.hasWorkspacesConnectionStatus() == other.hasWorkspacesConnectionStatus() && Objects.equals(this.workspacesConnectionStatus(), other.workspacesConnectionStatus()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspacesConnectionStatusResponse").add("WorkspacesConnectionStatus", this.hasWorkspacesConnectionStatus() ? this.workspacesConnectionStatus() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspacesConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.workspacesConnectionStatus()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesConnectionStatusResponse, T> g) {
        return obj -> g.apply((DescribeWorkspacesConnectionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspaceConnectionStatus> workspacesConnectionStatus = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesConnectionStatusResponse model) {
            super(model);
            this.workspacesConnectionStatus(model.workspacesConnectionStatus);
            this.nextToken(model.nextToken);
        }

        public final Collection<WorkspaceConnectionStatus.Builder> getWorkspacesConnectionStatus() {
            if (this.workspacesConnectionStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspacesConnectionStatus != null ? (Collection)this.workspacesConnectionStatus.stream().map(WorkspaceConnectionStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workspacesConnectionStatus(Collection<WorkspaceConnectionStatus> workspacesConnectionStatus) {
            this.workspacesConnectionStatus = WorkspaceConnectionStatusListCopier.copy(workspacesConnectionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesConnectionStatus(WorkspaceConnectionStatus ... workspacesConnectionStatus) {
            this.workspacesConnectionStatus(Arrays.asList(workspacesConnectionStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesConnectionStatus(Consumer<WorkspaceConnectionStatus.Builder> ... workspacesConnectionStatus) {
            this.workspacesConnectionStatus(Stream.of(workspacesConnectionStatus).map(c -> (WorkspaceConnectionStatus)((WorkspaceConnectionStatus.Builder)WorkspaceConnectionStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkspacesConnectionStatus(Collection<WorkspaceConnectionStatus.BuilderImpl> workspacesConnectionStatus) {
            this.workspacesConnectionStatus = WorkspaceConnectionStatusListCopier.copyFromBuilder(workspacesConnectionStatus);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeWorkspacesConnectionStatusResponse build() {
            return new DescribeWorkspacesConnectionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesConnectionStatusResponse> {
        public Builder workspacesConnectionStatus(Collection<WorkspaceConnectionStatus> var1);

        public Builder workspacesConnectionStatus(WorkspaceConnectionStatus ... var1);

        public Builder workspacesConnectionStatus(Consumer<WorkspaceConnectionStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

