/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImage;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceImagesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspaceImagesResponse> {
    private static final SdkField<List<WorkspaceImage>> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Images").getter(DescribeWorkspaceImagesResponse.getter(DescribeWorkspaceImagesResponse::images)).setter(DescribeWorkspaceImagesResponse.setter(Builder::images)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspaceImagesResponse.getter(DescribeWorkspaceImagesResponse::nextToken)).setter(DescribeWorkspaceImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGES_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorkspaceImage> images;
    private final String nextToken;

    private DescribeWorkspaceImagesResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImages() {
        return this.images != null && !(this.images instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceImage> images() {
        return this.images;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImages() ? this.images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceImagesResponse)) {
            return false;
        }
        DescribeWorkspaceImagesResponse other = (DescribeWorkspaceImagesResponse)((Object)obj);
        return this.hasImages() == other.hasImages() && Objects.equals(this.images(), other.images()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceImagesResponse").add("Images", this.hasImages() ? this.images() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceImagesResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspaceImage> images = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceImagesResponse model) {
            super(model);
            this.images(model.images);
            this.nextToken(model.nextToken);
        }

        public final Collection<WorkspaceImage.Builder> getImages() {
            if (this.images instanceof SdkAutoConstructList) {
                return null;
            }
            return this.images != null ? (Collection)this.images.stream().map(WorkspaceImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<WorkspaceImage> images) {
            this.images = WorkspaceImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(WorkspaceImage ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<WorkspaceImage.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (WorkspaceImage)((WorkspaceImage.Builder)WorkspaceImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<WorkspaceImage.BuilderImpl> images) {
            this.images = WorkspaceImageListCopier.copyFromBuilder(images);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeWorkspaceImagesResponse build() {
            return new DescribeWorkspaceImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceImagesResponse> {
        public Builder images(Collection<WorkspaceImage> var1);

        public Builder images(WorkspaceImage ... var1);

        public Builder images(Consumer<WorkspaceImage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

