/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ConnectionAliasAssociation;
import software.amazon.awssdk.services.workspaces.model.ConnectionAliasAssociationListCopier;
import software.amazon.awssdk.services.workspaces.model.ConnectionAliasState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionAlias
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionAlias> {
    private static final SdkField<String> CONNECTION_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionString").getter(ConnectionAlias.getter(ConnectionAlias::connectionString)).setter(ConnectionAlias.setter(Builder::connectionString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionString").build()}).build();
    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasId").getter(ConnectionAlias.getter(ConnectionAlias::aliasId)).setter(ConnectionAlias.setter(Builder::aliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ConnectionAlias.getter(ConnectionAlias::stateAsString)).setter(ConnectionAlias.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(ConnectionAlias.getter(ConnectionAlias::ownerAccountId)).setter(ConnectionAlias.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<List<ConnectionAliasAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(ConnectionAlias.getter(ConnectionAlias::associations)).setter(ConnectionAlias.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionAliasAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STRING_FIELD, ALIAS_ID_FIELD, STATE_FIELD, OWNER_ACCOUNT_ID_FIELD, ASSOCIATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectionString;
    private final String aliasId;
    private final String state;
    private final String ownerAccountId;
    private final List<ConnectionAliasAssociation> associations;

    private ConnectionAlias(BuilderImpl builder) {
        this.connectionString = builder.connectionString;
        this.aliasId = builder.aliasId;
        this.state = builder.state;
        this.ownerAccountId = builder.ownerAccountId;
        this.associations = builder.associations;
    }

    public final String connectionString() {
        return this.connectionString;
    }

    public final String aliasId() {
        return this.aliasId;
    }

    public final ConnectionAliasState state() {
        return ConnectionAliasState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<ConnectionAliasAssociation> associations() {
        return this.associations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionAlias)) {
            return false;
        }
        ConnectionAlias other = (ConnectionAlias)obj;
        return Objects.equals(this.connectionString(), other.connectionString()) && Objects.equals(this.aliasId(), other.aliasId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionAlias").add("ConnectionString", (Object)this.connectionString()).add("AliasId", (Object)this.aliasId()).add("State", (Object)this.stateAsString()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("Associations", this.hasAssociations() ? this.associations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionString": {
                return Optional.ofNullable(clazz.cast(this.connectionString()));
            }
            case "AliasId": {
                return Optional.ofNullable(clazz.cast(this.aliasId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionAlias, T> g) {
        return obj -> g.apply((ConnectionAlias)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionString;
        private String aliasId;
        private String state;
        private String ownerAccountId;
        private List<ConnectionAliasAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionAlias model) {
            this.connectionString(model.connectionString);
            this.aliasId(model.aliasId);
            this.state(model.state);
            this.ownerAccountId(model.ownerAccountId);
            this.associations(model.associations);
        }

        public final String getConnectionString() {
            return this.connectionString;
        }

        @Override
        public final Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public final void setConnectionString(String connectionString) {
            this.connectionString = connectionString;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConnectionAliasState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        public final Collection<ConnectionAliasAssociation.Builder> getAssociations() {
            if (this.associations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associations != null ? (Collection)this.associations.stream().map(ConnectionAliasAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<ConnectionAliasAssociation> associations) {
            this.associations = ConnectionAliasAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(ConnectionAliasAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<ConnectionAliasAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (ConnectionAliasAssociation)((ConnectionAliasAssociation.Builder)ConnectionAliasAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociations(Collection<ConnectionAliasAssociation.BuilderImpl> associations) {
            this.associations = ConnectionAliasAssociationListCopier.copyFromBuilder(associations);
        }

        public ConnectionAlias build() {
            return new ConnectionAlias(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionAlias> {
        public Builder connectionString(String var1);

        public Builder aliasId(String var1);

        public Builder state(String var1);

        public Builder state(ConnectionAliasState var1);

        public Builder ownerAccountId(String var1);

        public Builder associations(Collection<ConnectionAliasAssociation> var1);

        public Builder associations(ConnectionAliasAssociation ... var1);

        public Builder associations(Consumer<ConnectionAliasAssociation.Builder> ... var1);
    }
}

