/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the connection status of a WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceConnectionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceConnectionStatus.Builder, WorkspaceConnectionStatus> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceId").getter(getter(WorkspaceConnectionStatus::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionState").getter(getter(WorkspaceConnectionStatus::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()).build();

    private static final SdkField<Instant> CONNECTION_STATE_CHECK_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ConnectionStateCheckTimestamp")
            .getter(getter(WorkspaceConnectionStatus::connectionStateCheckTimestamp))
            .setter(setter(Builder::connectionStateCheckTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStateCheckTimestamp")
                    .build()).build();

    private static final SdkField<Instant> LAST_KNOWN_USER_CONNECTION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastKnownUserConnectionTimestamp")
            .getter(getter(WorkspaceConnectionStatus::lastKnownUserConnectionTimestamp))
            .setter(setter(Builder::lastKnownUserConnectionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastKnownUserConnectionTimestamp")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            CONNECTION_STATE_FIELD, CONNECTION_STATE_CHECK_TIMESTAMP_FIELD, LAST_KNOWN_USER_CONNECTION_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workspaceId;

    private final String connectionState;

    private final Instant connectionStateCheckTimestamp;

    private final Instant lastKnownUserConnectionTimestamp;

    private WorkspaceConnectionStatus(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.connectionState = builder.connectionState;
        this.connectionStateCheckTimestamp = builder.connectionStateCheckTimestamp;
        this.lastKnownUserConnectionTimestamp = builder.lastKnownUserConnectionTimestamp;
    }

    /**
     * <p>
     * The identifier of the WorkSpace.
     * </p>
     * 
     * @return The identifier of the WorkSpace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
     * @see ConnectionState
     */
    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(connectionState);
    }

    /**
     * <p>
     * The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
     * @see ConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * <p>
     * The timestamp of the connection status check.
     * </p>
     * 
     * @return The timestamp of the connection status check.
     */
    public final Instant connectionStateCheckTimestamp() {
        return connectionStateCheckTimestamp;
    }

    /**
     * <p>
     * The timestamp of the last known user connection.
     * </p>
     * 
     * @return The timestamp of the last known user connection.
     */
    public final Instant lastKnownUserConnectionTimestamp() {
        return lastKnownUserConnectionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastKnownUserConnectionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceConnectionStatus)) {
            return false;
        }
        WorkspaceConnectionStatus other = (WorkspaceConnectionStatus) obj;
        return Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(connectionStateCheckTimestamp(), other.connectionStateCheckTimestamp())
                && Objects.equals(lastKnownUserConnectionTimestamp(), other.lastKnownUserConnectionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceConnectionStatus").add("WorkspaceId", workspaceId())
                .add("ConnectionState", connectionStateAsString())
                .add("ConnectionStateCheckTimestamp", connectionStateCheckTimestamp())
                .add("LastKnownUserConnectionTimestamp", lastKnownUserConnectionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "ConnectionStateCheckTimestamp":
            return Optional.ofNullable(clazz.cast(connectionStateCheckTimestamp()));
        case "LastKnownUserConnectionTimestamp":
            return Optional.ofNullable(clazz.cast(lastKnownUserConnectionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceConnectionStatus, T> g) {
        return obj -> g.apply((WorkspaceConnectionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceConnectionStatus> {
        /**
         * <p>
         * The identifier of the WorkSpace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
         * </p>
         * 
         * @param connectionState
         *        The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * <p>
         * The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
         * </p>
         * 
         * @param connectionState
         *        The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(ConnectionState connectionState);

        /**
         * <p>
         * The timestamp of the connection status check.
         * </p>
         * 
         * @param connectionStateCheckTimestamp
         *        The timestamp of the connection status check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStateCheckTimestamp(Instant connectionStateCheckTimestamp);

        /**
         * <p>
         * The timestamp of the last known user connection.
         * </p>
         * 
         * @param lastKnownUserConnectionTimestamp
         *        The timestamp of the last known user connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastKnownUserConnectionTimestamp(Instant lastKnownUserConnectionTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String workspaceId;

        private String connectionState;

        private Instant connectionStateCheckTimestamp;

        private Instant lastKnownUserConnectionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceConnectionStatus model) {
            workspaceId(model.workspaceId);
            connectionState(model.connectionState);
            connectionStateCheckTimestamp(model.connectionStateCheckTimestamp);
            lastKnownUserConnectionTimestamp(model.lastKnownUserConnectionTimestamp);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final Instant getConnectionStateCheckTimestamp() {
            return connectionStateCheckTimestamp;
        }

        @Override
        public final Builder connectionStateCheckTimestamp(Instant connectionStateCheckTimestamp) {
            this.connectionStateCheckTimestamp = connectionStateCheckTimestamp;
            return this;
        }

        public final void setConnectionStateCheckTimestamp(Instant connectionStateCheckTimestamp) {
            this.connectionStateCheckTimestamp = connectionStateCheckTimestamp;
        }

        public final Instant getLastKnownUserConnectionTimestamp() {
            return lastKnownUserConnectionTimestamp;
        }

        @Override
        public final Builder lastKnownUserConnectionTimestamp(Instant lastKnownUserConnectionTimestamp) {
            this.lastKnownUserConnectionTimestamp = lastKnownUserConnectionTimestamp;
            return this;
        }

        public final void setLastKnownUserConnectionTimestamp(Instant lastKnownUserConnectionTimestamp) {
            this.lastKnownUserConnectionTimestamp = lastKnownUserConnectionTimestamp;
        }

        @Override
        public WorkspaceConnectionStatus build() {
            return new WorkspaceConnectionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
