/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyAccountRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyAccountRequest.Builder, ModifyAccountRequest> {
    private static final SdkField<String> DEDICATED_TENANCY_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancySupport").getter(getter(ModifyAccountRequest::dedicatedTenancySupportAsString))
            .setter(setter(Builder::dedicatedTenancySupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancySupport").build())
            .build();

    private static final SdkField<String> DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancyManagementCidrRange")
            .getter(getter(ModifyAccountRequest::dedicatedTenancyManagementCidrRange))
            .setter(setter(Builder::dedicatedTenancyManagementCidrRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DedicatedTenancyManagementCidrRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEDICATED_TENANCY_SUPPORT_FIELD, DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD));

    private final String dedicatedTenancySupport;

    private final String dedicatedTenancyManagementCidrRange;

    private ModifyAccountRequest(BuilderImpl builder) {
        super(builder);
        this.dedicatedTenancySupport = builder.dedicatedTenancySupport;
        this.dedicatedTenancyManagementCidrRange = builder.dedicatedTenancyManagementCidrRange;
    }

    /**
     * <p>
     * The status of BYOL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL.
     * @see DedicatedTenancySupportEnum
     */
    public final DedicatedTenancySupportEnum dedicatedTenancySupport() {
        return DedicatedTenancySupportEnum.fromValue(dedicatedTenancySupport);
    }

    /**
     * <p>
     * The status of BYOL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL.
     * @see DedicatedTenancySupportEnum
     */
    public final String dedicatedTenancySupportAsString() {
        return dedicatedTenancySupport;
    }

    /**
     * <p>
     * The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP
     * address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4
     * CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as
     * available by the <code>ListAvailableManagementCidrRanges</code> operation.
     * </p>
     * 
     * @return The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an
     *         IP address range that is compatible with your network and in CIDR notation (that is, specify the range as
     *         an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be
     *         specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.
     */
    public final String dedicatedTenancyManagementCidrRange() {
        return dedicatedTenancyManagementCidrRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancySupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancyManagementCidrRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyAccountRequest)) {
            return false;
        }
        ModifyAccountRequest other = (ModifyAccountRequest) obj;
        return Objects.equals(dedicatedTenancySupportAsString(), other.dedicatedTenancySupportAsString())
                && Objects.equals(dedicatedTenancyManagementCidrRange(), other.dedicatedTenancyManagementCidrRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyAccountRequest").add("DedicatedTenancySupport", dedicatedTenancySupportAsString())
                .add("DedicatedTenancyManagementCidrRange", dedicatedTenancyManagementCidrRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DedicatedTenancySupport":
            return Optional.ofNullable(clazz.cast(dedicatedTenancySupportAsString()));
        case "DedicatedTenancyManagementCidrRange":
            return Optional.ofNullable(clazz.cast(dedicatedTenancyManagementCidrRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyAccountRequest, T> g) {
        return obj -> g.apply((ModifyAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyAccountRequest> {
        /**
         * <p>
         * The status of BYOL.
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL.
         * @see DedicatedTenancySupportEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportEnum
         */
        Builder dedicatedTenancySupport(String dedicatedTenancySupport);

        /**
         * <p>
         * The status of BYOL.
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL.
         * @see DedicatedTenancySupportEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportEnum
         */
        Builder dedicatedTenancySupport(DedicatedTenancySupportEnum dedicatedTenancySupport);

        /**
         * <p>
         * The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP
         * address range that is compatible with your network and in CIDR notation (that is, specify the range as an
         * IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified
         * as available by the <code>ListAvailableManagementCidrRanges</code> operation.
         * </p>
         * 
         * @param dedicatedTenancyManagementCidrRange
         *        The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify
         *        an IP address range that is compatible with your network and in CIDR notation (that is, specify the
         *        range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must
         *        also be specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String dedicatedTenancySupport;

        private String dedicatedTenancyManagementCidrRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyAccountRequest model) {
            super(model);
            dedicatedTenancySupport(model.dedicatedTenancySupport);
            dedicatedTenancyManagementCidrRange(model.dedicatedTenancyManagementCidrRange);
        }

        public final String getDedicatedTenancySupport() {
            return dedicatedTenancySupport;
        }

        @Override
        public final Builder dedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
            return this;
        }

        @Override
        public final Builder dedicatedTenancySupport(DedicatedTenancySupportEnum dedicatedTenancySupport) {
            this.dedicatedTenancySupport(dedicatedTenancySupport == null ? null : dedicatedTenancySupport.toString());
            return this;
        }

        public final void setDedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
        }

        public final String getDedicatedTenancyManagementCidrRange() {
            return dedicatedTenancyManagementCidrRange;
        }

        @Override
        public final Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
            return this;
        }

        public final void setDedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyAccountRequest build() {
            return new ModifyAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
