/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspacesConnectionStatusRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspacesConnectionStatusRequest.Builder, DescribeWorkspacesConnectionStatusRequest> {
    private static final SdkField<List<String>> WORKSPACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WorkspaceIds")
            .getter(getter(DescribeWorkspacesConnectionStatusRequest::workspaceIds))
            .setter(setter(Builder::workspaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspacesConnectionStatusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> workspaceIds;

    private final String nextToken;

    private DescribeWorkspacesConnectionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceIds = builder.workspaceIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the WorkspaceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasWorkspaceIds() {
        return workspaceIds != null && !(workspaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorkspaceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
     */
    public final List<String> workspaceIds() {
        return workspaceIds;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceIds() ? workspaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesConnectionStatusRequest)) {
            return false;
        }
        DescribeWorkspacesConnectionStatusRequest other = (DescribeWorkspacesConnectionStatusRequest) obj;
        return hasWorkspaceIds() == other.hasWorkspaceIds() && Objects.equals(workspaceIds(), other.workspaceIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspacesConnectionStatusRequest")
                .add("WorkspaceIds", hasWorkspaceIds() ? workspaceIds() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceIds":
            return Optional.ofNullable(clazz.cast(workspaceIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesConnectionStatusRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesConnectionStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspacesConnectionStatusRequest> {
        /**
         * <p>
         * The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param workspaceIds
         *        The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceIds(Collection<String> workspaceIds);

        /**
         * <p>
         * The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param workspaceIds
         *        The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceIds(String... workspaceIds);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> workspaceIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesConnectionStatusRequest model) {
            super(model);
            workspaceIds(model.workspaceIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getWorkspaceIds() {
            if (workspaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceIds;
        }

        @Override
        public final Builder workspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceIds(String... workspaceIds) {
            workspaceIds(Arrays.asList(workspaceIds));
            return this;
        }

        public final void setWorkspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesConnectionStatusRequest build() {
            return new DescribeWorkspacesConnectionStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
