/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceSnapshotsResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeWorkspaceSnapshotsResponse.Builder, DescribeWorkspaceSnapshotsResponse> {
    private static final SdkField<List<Snapshot>> REBUILD_SNAPSHOTS_FIELD = SdkField
            .<List<Snapshot>> builder(MarshallingType.LIST)
            .memberName("RebuildSnapshots")
            .getter(getter(DescribeWorkspaceSnapshotsResponse::rebuildSnapshots))
            .setter(setter(Builder::rebuildSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildSnapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Snapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Snapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Snapshot>> RESTORE_SNAPSHOTS_FIELD = SdkField
            .<List<Snapshot>> builder(MarshallingType.LIST)
            .memberName("RestoreSnapshots")
            .getter(getter(DescribeWorkspaceSnapshotsResponse::restoreSnapshots))
            .setter(setter(Builder::restoreSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreSnapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Snapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Snapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REBUILD_SNAPSHOTS_FIELD,
            RESTORE_SNAPSHOTS_FIELD));

    private final List<Snapshot> rebuildSnapshots;

    private final List<Snapshot> restoreSnapshots;

    private DescribeWorkspaceSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.rebuildSnapshots = builder.rebuildSnapshots;
        this.restoreSnapshots = builder.restoreSnapshots;
    }

    /**
     * Returns true if the RebuildSnapshots property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRebuildSnapshots() {
        return rebuildSnapshots != null && !(rebuildSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the user volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRebuildSnapshots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the user
     *         volume.
     */
    public final List<Snapshot> rebuildSnapshots() {
        return rebuildSnapshots;
    }

    /**
     * Returns true if the RestoreSnapshots property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRestoreSnapshots() {
        return restoreSnapshots != null && !(restoreSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both the root
     * volume and the user volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRestoreSnapshots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both the
     *         root volume and the user volume.
     */
    public final List<Snapshot> restoreSnapshots() {
        return restoreSnapshots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRebuildSnapshots() ? rebuildSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreSnapshots() ? restoreSnapshots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceSnapshotsResponse)) {
            return false;
        }
        DescribeWorkspaceSnapshotsResponse other = (DescribeWorkspaceSnapshotsResponse) obj;
        return hasRebuildSnapshots() == other.hasRebuildSnapshots()
                && Objects.equals(rebuildSnapshots(), other.rebuildSnapshots())
                && hasRestoreSnapshots() == other.hasRestoreSnapshots()
                && Objects.equals(restoreSnapshots(), other.restoreSnapshots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceSnapshotsResponse")
                .add("RebuildSnapshots", hasRebuildSnapshots() ? rebuildSnapshots() : null)
                .add("RestoreSnapshots", hasRestoreSnapshots() ? restoreSnapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RebuildSnapshots":
            return Optional.ofNullable(clazz.cast(rebuildSnapshots()));
        case "RestoreSnapshots":
            return Optional.ofNullable(clazz.cast(restoreSnapshots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceSnapshotsResponse> {
        /**
         * <p>
         * Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the user
         * volume.
         * </p>
         * 
         * @param rebuildSnapshots
         *        Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the
         *        user volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebuildSnapshots(Collection<Snapshot> rebuildSnapshots);

        /**
         * <p>
         * Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the user
         * volume.
         * </p>
         * 
         * @param rebuildSnapshots
         *        Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the
         *        user volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebuildSnapshots(Snapshot... rebuildSnapshots);

        /**
         * <p>
         * Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the user
         * volume.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Snapshot>.Builder} avoiding the need to
         * create one manually via {@link List<Snapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Snapshot>.Builder#build()} is called immediately and its
         * result is passed to {@link #rebuildSnapshots(List<Snapshot>)}.
         * 
         * @param rebuildSnapshots
         *        a consumer that will call methods on {@link List<Snapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rebuildSnapshots(List<Snapshot>)
         */
        Builder rebuildSnapshots(Consumer<Snapshot.Builder>... rebuildSnapshots);

        /**
         * <p>
         * Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both the
         * root volume and the user volume.
         * </p>
         * 
         * @param restoreSnapshots
         *        Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both
         *        the root volume and the user volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreSnapshots(Collection<Snapshot> restoreSnapshots);

        /**
         * <p>
         * Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both the
         * root volume and the user volume.
         * </p>
         * 
         * @param restoreSnapshots
         *        Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both
         *        the root volume and the user volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreSnapshots(Snapshot... restoreSnapshots);

        /**
         * <p>
         * Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both the
         * root volume and the user volume.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Snapshot>.Builder} avoiding the need to
         * create one manually via {@link List<Snapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Snapshot>.Builder#build()} is called immediately and its
         * result is passed to {@link #restoreSnapshots(List<Snapshot>)}.
         * 
         * @param restoreSnapshots
         *        a consumer that will call methods on {@link List<Snapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreSnapshots(List<Snapshot>)
         */
        Builder restoreSnapshots(Consumer<Snapshot.Builder>... restoreSnapshots);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<Snapshot> rebuildSnapshots = DefaultSdkAutoConstructList.getInstance();

        private List<Snapshot> restoreSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceSnapshotsResponse model) {
            super(model);
            rebuildSnapshots(model.rebuildSnapshots);
            restoreSnapshots(model.restoreSnapshots);
        }

        public final Collection<Snapshot.Builder> getRebuildSnapshots() {
            if (rebuildSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return rebuildSnapshots != null ? rebuildSnapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder rebuildSnapshots(Collection<Snapshot> rebuildSnapshots) {
            this.rebuildSnapshots = SnapshotListCopier.copy(rebuildSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildSnapshots(Snapshot... rebuildSnapshots) {
            rebuildSnapshots(Arrays.asList(rebuildSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildSnapshots(Consumer<Snapshot.Builder>... rebuildSnapshots) {
            rebuildSnapshots(Stream.of(rebuildSnapshots).map(c -> Snapshot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRebuildSnapshots(Collection<Snapshot.BuilderImpl> rebuildSnapshots) {
            this.rebuildSnapshots = SnapshotListCopier.copyFromBuilder(rebuildSnapshots);
        }

        public final Collection<Snapshot.Builder> getRestoreSnapshots() {
            if (restoreSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return restoreSnapshots != null ? restoreSnapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder restoreSnapshots(Collection<Snapshot> restoreSnapshots) {
            this.restoreSnapshots = SnapshotListCopier.copy(restoreSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreSnapshots(Snapshot... restoreSnapshots) {
            restoreSnapshots(Arrays.asList(restoreSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreSnapshots(Consumer<Snapshot.Builder>... restoreSnapshots) {
            restoreSnapshots(Stream.of(restoreSnapshots).map(c -> Snapshot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRestoreSnapshots(Collection<Snapshot.BuilderImpl> restoreSnapshots) {
            this.restoreSnapshots = SnapshotListCopier.copyFromBuilder(restoreSnapshots);
        }

        @Override
        public DescribeWorkspaceSnapshotsResponse build() {
            return new DescribeWorkspaceSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
