/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIpGroupsResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeIpGroupsResponse.Builder, DescribeIpGroupsResponse> {
    private static final SdkField<List<WorkspacesIpGroup>> RESULT_FIELD = SdkField
            .<List<WorkspacesIpGroup>> builder(MarshallingType.LIST)
            .memberName("Result")
            .getter(getter(DescribeIpGroupsResponse::result))
            .setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspacesIpGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspacesIpGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeIpGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESULT_FIELD, NEXT_TOKEN_FIELD));

    private final List<WorkspacesIpGroup> result;

    private final String nextToken;

    private DescribeIpGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Result property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResult() {
        return result != null && !(result instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IP access control groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResult()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the IP access control groups.
     */
    public final List<WorkspacesIpGroup> result() {
        return result;
    }

    /**
     * <p>
     * The token to use to retrieve the next set of results, or null if no more results are available.
     * </p>
     * 
     * @return The token to use to retrieve the next set of results, or null if no more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResult() ? result() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpGroupsResponse)) {
            return false;
        }
        DescribeIpGroupsResponse other = (DescribeIpGroupsResponse) obj;
        return hasResult() == other.hasResult() && Objects.equals(result(), other.result())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIpGroupsResponse").add("Result", hasResult() ? result() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpGroupsResponse, T> g) {
        return obj -> g.apply((DescribeIpGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIpGroupsResponse> {
        /**
         * <p>
         * Information about the IP access control groups.
         * </p>
         * 
         * @param result
         *        Information about the IP access control groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Collection<WorkspacesIpGroup> result);

        /**
         * <p>
         * Information about the IP access control groups.
         * </p>
         * 
         * @param result
         *        Information about the IP access control groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(WorkspacesIpGroup... result);

        /**
         * <p>
         * Information about the IP access control groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkspacesIpGroup>.Builder} avoiding the
         * need to create one manually via {@link List<WorkspacesIpGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkspacesIpGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #result(List<WorkspacesIpGroup>)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link List<WorkspacesIpGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(List<WorkspacesIpGroup>)
         */
        Builder result(Consumer<WorkspacesIpGroup.Builder>... result);

        /**
         * <p>
         * The token to use to retrieve the next set of results, or null if no more results are available.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next set of results, or null if no more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<WorkspacesIpGroup> result = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpGroupsResponse model) {
            super(model);
            result(model.result);
            nextToken(model.nextToken);
        }

        public final Collection<WorkspacesIpGroup.Builder> getResult() {
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result != null ? result.stream().map(WorkspacesIpGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder result(Collection<WorkspacesIpGroup> result) {
            this.result = WorkspacesIpGroupsListCopier.copy(result);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder result(WorkspacesIpGroup... result) {
            result(Arrays.asList(result));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder result(Consumer<WorkspacesIpGroup.Builder>... result) {
            result(Stream.of(result).map(c -> WorkspacesIpGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResult(Collection<WorkspacesIpGroup.BuilderImpl> result) {
            this.result = WorkspacesIpGroupsListCopier.copyFromBuilder(result);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeIpGroupsResponse build() {
            return new DescribeIpGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
