/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspacesResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<CreateWorkspacesResponse.Builder, CreateWorkspacesResponse> {
    private static final SdkField<List<FailedCreateWorkspaceRequest>> FAILED_REQUESTS_FIELD = SdkField
            .<List<FailedCreateWorkspaceRequest>> builder(MarshallingType.LIST)
            .memberName("FailedRequests")
            .getter(getter(CreateWorkspacesResponse::failedRequests))
            .setter(setter(Builder::failedRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedCreateWorkspaceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedCreateWorkspaceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Workspace>> PENDING_REQUESTS_FIELD = SdkField
            .<List<Workspace>> builder(MarshallingType.LIST)
            .memberName("PendingRequests")
            .getter(getter(CreateWorkspacesResponse::pendingRequests))
            .setter(setter(Builder::pendingRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workspace> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workspace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_REQUESTS_FIELD,
            PENDING_REQUESTS_FIELD));

    private final List<FailedCreateWorkspaceRequest> failedRequests;

    private final List<Workspace> pendingRequests;

    private CreateWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.failedRequests = builder.failedRequests;
        this.pendingRequests = builder.pendingRequests;
    }

    /**
     * Returns true if the FailedRequests property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailedRequests() {
        return failedRequests != null && !(failedRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the WorkSpaces that could not be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the WorkSpaces that could not be created.
     */
    public final List<FailedCreateWorkspaceRequest> failedRequests() {
        return failedRequests;
    }

    /**
     * Returns true if the PendingRequests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPendingRequests() {
        return pendingRequests != null && !(pendingRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the WorkSpaces that were created.
     * </p>
     * <p>
     * Because this operation is asynchronous, the identifier returned is not immediately available for use with other
     * operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is created, the information
     * returned can be incomplete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPendingRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the WorkSpaces that were created.</p>
     *         <p>
     *         Because this operation is asynchronous, the identifier returned is not immediately available for use with
     *         other operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is created, the
     *         information returned can be incomplete.
     */
    public final List<Workspace> pendingRequests() {
        return pendingRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedRequests() ? failedRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingRequests() ? pendingRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesResponse)) {
            return false;
        }
        CreateWorkspacesResponse other = (CreateWorkspacesResponse) obj;
        return hasFailedRequests() == other.hasFailedRequests() && Objects.equals(failedRequests(), other.failedRequests())
                && hasPendingRequests() == other.hasPendingRequests()
                && Objects.equals(pendingRequests(), other.pendingRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspacesResponse").add("FailedRequests", hasFailedRequests() ? failedRequests() : null)
                .add("PendingRequests", hasPendingRequests() ? pendingRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedRequests":
            return Optional.ofNullable(clazz.cast(failedRequests()));
        case "PendingRequests":
            return Optional.ofNullable(clazz.cast(pendingRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspacesResponse, T> g) {
        return obj -> g.apply((CreateWorkspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspacesResponse> {
        /**
         * <p>
         * Information about the WorkSpaces that could not be created.
         * </p>
         * 
         * @param failedRequests
         *        Information about the WorkSpaces that could not be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(Collection<FailedCreateWorkspaceRequest> failedRequests);

        /**
         * <p>
         * Information about the WorkSpaces that could not be created.
         * </p>
         * 
         * @param failedRequests
         *        Information about the WorkSpaces that could not be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(FailedCreateWorkspaceRequest... failedRequests);

        /**
         * <p>
         * Information about the WorkSpaces that could not be created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedCreateWorkspaceRequest>.Builder}
         * avoiding the need to create one manually via {@link List<FailedCreateWorkspaceRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedCreateWorkspaceRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedRequests(List<FailedCreateWorkspaceRequest>)}.
         * 
         * @param failedRequests
         *        a consumer that will call methods on {@link List<FailedCreateWorkspaceRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedRequests(List<FailedCreateWorkspaceRequest>)
         */
        Builder failedRequests(Consumer<FailedCreateWorkspaceRequest.Builder>... failedRequests);

        /**
         * <p>
         * Information about the WorkSpaces that were created.
         * </p>
         * <p>
         * Because this operation is asynchronous, the identifier returned is not immediately available for use with
         * other operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is created, the
         * information returned can be incomplete.
         * </p>
         * 
         * @param pendingRequests
         *        Information about the WorkSpaces that were created.</p>
         *        <p>
         *        Because this operation is asynchronous, the identifier returned is not immediately available for use
         *        with other operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is
         *        created, the information returned can be incomplete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingRequests(Collection<Workspace> pendingRequests);

        /**
         * <p>
         * Information about the WorkSpaces that were created.
         * </p>
         * <p>
         * Because this operation is asynchronous, the identifier returned is not immediately available for use with
         * other operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is created, the
         * information returned can be incomplete.
         * </p>
         * 
         * @param pendingRequests
         *        Information about the WorkSpaces that were created.</p>
         *        <p>
         *        Because this operation is asynchronous, the identifier returned is not immediately available for use
         *        with other operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is
         *        created, the information returned can be incomplete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingRequests(Workspace... pendingRequests);

        /**
         * <p>
         * Information about the WorkSpaces that were created.
         * </p>
         * <p>
         * Because this operation is asynchronous, the identifier returned is not immediately available for use with
         * other operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is created, the
         * information returned can be incomplete.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Workspace>.Builder} avoiding the need to
         * create one manually via {@link List<Workspace>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Workspace>.Builder#build()} is called immediately and its
         * result is passed to {@link #pendingRequests(List<Workspace>)}.
         * 
         * @param pendingRequests
         *        a consumer that will call methods on {@link List<Workspace>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingRequests(List<Workspace>)
         */
        Builder pendingRequests(Consumer<Workspace.Builder>... pendingRequests);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<FailedCreateWorkspaceRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();

        private List<Workspace> pendingRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspacesResponse model) {
            super(model);
            failedRequests(model.failedRequests);
            pendingRequests(model.pendingRequests);
        }

        public final Collection<FailedCreateWorkspaceRequest.Builder> getFailedRequests() {
            if (failedRequests instanceof SdkAutoConstructList) {
                return null;
            }
            return failedRequests != null ? failedRequests.stream().map(FailedCreateWorkspaceRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedRequests(Collection<FailedCreateWorkspaceRequest> failedRequests) {
            this.failedRequests = FailedCreateWorkspaceRequestsCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedCreateWorkspaceRequest... failedRequests) {
            failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedCreateWorkspaceRequest.Builder>... failedRequests) {
            failedRequests(Stream.of(failedRequests).map(c -> FailedCreateWorkspaceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedRequests(Collection<FailedCreateWorkspaceRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedCreateWorkspaceRequestsCopier.copyFromBuilder(failedRequests);
        }

        public final Collection<Workspace.Builder> getPendingRequests() {
            if (pendingRequests instanceof SdkAutoConstructList) {
                return null;
            }
            return pendingRequests != null ? pendingRequests.stream().map(Workspace::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder pendingRequests(Collection<Workspace> pendingRequests) {
            this.pendingRequests = WorkspaceListCopier.copy(pendingRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(Workspace... pendingRequests) {
            pendingRequests(Arrays.asList(pendingRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(Consumer<Workspace.Builder>... pendingRequests) {
            pendingRequests(Stream.of(pendingRequests).map(c -> Workspace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPendingRequests(Collection<Workspace.BuilderImpl> pendingRequests) {
            this.pendingRequests = WorkspaceListCopier.copyFromBuilder(pendingRequests);
        }

        @Override
        public CreateWorkspacesResponse build() {
            return new CreateWorkspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
