/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrateWorkspaceRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, MigrateWorkspaceRequest> {
    private static final SdkField<String> SOURCE_WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MigrateWorkspaceRequest.getter(MigrateWorkspaceRequest::sourceWorkspaceId)).setter(MigrateWorkspaceRequest.setter(Builder::sourceWorkspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceWorkspaceId").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MigrateWorkspaceRequest.getter(MigrateWorkspaceRequest::bundleId)).setter(MigrateWorkspaceRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_WORKSPACE_ID_FIELD, BUNDLE_ID_FIELD));
    private final String sourceWorkspaceId;
    private final String bundleId;

    private MigrateWorkspaceRequest(BuilderImpl builder) {
        super(builder);
        this.sourceWorkspaceId = builder.sourceWorkspaceId;
        this.bundleId = builder.bundleId;
    }

    public String sourceWorkspaceId() {
        return this.sourceWorkspaceId;
    }

    public String bundleId() {
        return this.bundleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrateWorkspaceRequest)) {
            return false;
        }
        MigrateWorkspaceRequest other = (MigrateWorkspaceRequest)((Object)obj);
        return Objects.equals(this.sourceWorkspaceId(), other.sourceWorkspaceId()) && Objects.equals(this.bundleId(), other.bundleId());
    }

    public String toString() {
        return ToString.builder((String)"MigrateWorkspaceRequest").add("SourceWorkspaceId", (Object)this.sourceWorkspaceId()).add("BundleId", (Object)this.bundleId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceWorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.sourceWorkspaceId()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrateWorkspaceRequest, T> g) {
        return obj -> g.apply((MigrateWorkspaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String sourceWorkspaceId;
        private String bundleId;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrateWorkspaceRequest model) {
            super(model);
            this.sourceWorkspaceId(model.sourceWorkspaceId);
            this.bundleId(model.bundleId);
        }

        public final String getSourceWorkspaceId() {
            return this.sourceWorkspaceId;
        }

        @Override
        public final Builder sourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
            return this;
        }

        public final void setSourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MigrateWorkspaceRequest build() {
            return new MigrateWorkspaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MigrateWorkspaceRequest> {
        public Builder sourceWorkspaceId(String var1);

        public Builder bundleId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

