/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.DirectoryListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceDirectoriesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspaceDirectoriesResponse> {
    private static final SdkField<List<WorkspaceDirectory>> DIRECTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeWorkspaceDirectoriesResponse.getter(DescribeWorkspaceDirectoriesResponse::directories)).setter(DescribeWorkspaceDirectoriesResponse.setter(Builder::directories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Directories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceDirectory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspaceDirectoriesResponse.getter(DescribeWorkspaceDirectoriesResponse::nextToken)).setter(DescribeWorkspaceDirectoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorkspaceDirectory> directories;
    private final String nextToken;

    private DescribeWorkspaceDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.directories = builder.directories;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDirectories() {
        return this.directories != null && !(this.directories instanceof SdkAutoConstructList);
    }

    public List<WorkspaceDirectory> directories() {
        return this.directories;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directories());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceDirectoriesResponse)) {
            return false;
        }
        DescribeWorkspaceDirectoriesResponse other = (DescribeWorkspaceDirectoriesResponse)((Object)obj);
        return Objects.equals(this.directories(), other.directories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorkspaceDirectoriesResponse").add("Directories", this.directories()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Directories": {
                return Optional.ofNullable(clazz.cast(this.directories()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceDirectoriesResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceDirectoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspaceDirectory> directories = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceDirectoriesResponse model) {
            super(model);
            this.directories(model.directories);
            this.nextToken(model.nextToken);
        }

        public final Collection<WorkspaceDirectory.Builder> getDirectories() {
            return this.directories != null ? (Collection)this.directories.stream().map(WorkspaceDirectory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directories(Collection<WorkspaceDirectory> directories) {
            this.directories = DirectoryListCopier.copy(directories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directories(WorkspaceDirectory ... directories) {
            this.directories(Arrays.asList(directories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directories(Consumer<WorkspaceDirectory.Builder> ... directories) {
            this.directories(Stream.of(directories).map(c -> (WorkspaceDirectory)((WorkspaceDirectory.Builder)WorkspaceDirectory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDirectories(Collection<WorkspaceDirectory.BuilderImpl> directories) {
            this.directories = DirectoryListCopier.copyFromBuilder(directories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeWorkspaceDirectoriesResponse build() {
            return new DescribeWorkspaceDirectoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceDirectoriesResponse> {
        public Builder directories(Collection<WorkspaceDirectory> var1);

        public Builder directories(WorkspaceDirectory ... var1);

        public Builder directories(Consumer<WorkspaceDirectory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

