/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, CreateWorkspacesRequest> {
    private static final SdkField<List<WorkspaceRequest>> WORKSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateWorkspacesRequest.getter(CreateWorkspacesRequest::workspaces)).setter(CreateWorkspacesRequest.setter(Builder::workspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACES_FIELD));
    private final List<WorkspaceRequest> workspaces;

    private CreateWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.workspaces = builder.workspaces;
    }

    public boolean hasWorkspaces() {
        return this.workspaces != null && !(this.workspaces instanceof SdkAutoConstructList);
    }

    public List<WorkspaceRequest> workspaces() {
        return this.workspaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaces());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesRequest)) {
            return false;
        }
        CreateWorkspacesRequest other = (CreateWorkspacesRequest)((Object)obj);
        return Objects.equals(this.workspaces(), other.workspaces());
    }

    public String toString() {
        return ToString.builder((String)"CreateWorkspacesRequest").add("Workspaces", this.workspaces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Workspaces": {
                return Optional.ofNullable(clazz.cast(this.workspaces()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspacesRequest, T> g) {
        return obj -> g.apply((CreateWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<WorkspaceRequest> workspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspacesRequest model) {
            super(model);
            this.workspaces(model.workspaces);
        }

        public final Collection<WorkspaceRequest.Builder> getWorkspaces() {
            return this.workspaces != null ? (Collection)this.workspaces.stream().map(WorkspaceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workspaces(Collection<WorkspaceRequest> workspaces) {
            this.workspaces = WorkspaceRequestListCopier.copy(workspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(WorkspaceRequest ... workspaces) {
            this.workspaces(Arrays.asList(workspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Consumer<WorkspaceRequest.Builder> ... workspaces) {
            this.workspaces(Stream.of(workspaces).map(c -> (WorkspaceRequest)((WorkspaceRequest.Builder)WorkspaceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkspaces(Collection<WorkspaceRequest.BuilderImpl> workspaces) {
            this.workspaces = WorkspaceRequestListCopier.copyFromBuilder(workspaces);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspacesRequest build() {
            return new CreateWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspacesRequest> {
        public Builder workspaces(Collection<WorkspaceRequest> var1);

        public Builder workspaces(WorkspaceRequest ... var1);

        public Builder workspaces(Consumer<WorkspaceRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

