/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyWorkspaceStateRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyWorkspaceStateRequest.Builder, ModifyWorkspaceStateRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyWorkspaceStateRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()).build();

    private static final SdkField<String> WORKSPACE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyWorkspaceStateRequest::workspaceStateAsString)).setter(setter(Builder::workspaceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            WORKSPACE_STATE_FIELD));

    private final String workspaceId;

    private final String workspaceState;

    private ModifyWorkspaceStateRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.workspaceState = builder.workspaceState;
    }

    /**
     * <p>
     * The identifier of the WorkSpace.
     * </p>
     * 
     * @return The identifier of the WorkSpace.
     */
    public String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The WorkSpace state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workspaceState}
     * will return {@link TargetWorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #workspaceStateAsString}.
     * </p>
     * 
     * @return The WorkSpace state.
     * @see TargetWorkspaceState
     */
    public TargetWorkspaceState workspaceState() {
        return TargetWorkspaceState.fromValue(workspaceState);
    }

    /**
     * <p>
     * The WorkSpace state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workspaceState}
     * will return {@link TargetWorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #workspaceStateAsString}.
     * </p>
     * 
     * @return The WorkSpace state.
     * @see TargetWorkspaceState
     */
    public String workspaceStateAsString() {
        return workspaceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyWorkspaceStateRequest)) {
            return false;
        }
        ModifyWorkspaceStateRequest other = (ModifyWorkspaceStateRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(workspaceStateAsString(), other.workspaceStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyWorkspaceStateRequest").add("WorkspaceId", workspaceId())
                .add("WorkspaceState", workspaceStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "WorkspaceState":
            return Optional.ofNullable(clazz.cast(workspaceStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyWorkspaceStateRequest, T> g) {
        return obj -> g.apply((ModifyWorkspaceStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyWorkspaceStateRequest> {
        /**
         * <p>
         * The identifier of the WorkSpace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The WorkSpace state.
         * </p>
         * 
         * @param workspaceState
         *        The WorkSpace state.
         * @see TargetWorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetWorkspaceState
         */
        Builder workspaceState(String workspaceState);

        /**
         * <p>
         * The WorkSpace state.
         * </p>
         * 
         * @param workspaceState
         *        The WorkSpace state.
         * @see TargetWorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetWorkspaceState
         */
        Builder workspaceState(TargetWorkspaceState workspaceState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String workspaceState;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyWorkspaceStateRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            workspaceState(model.workspaceState);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public final String getWorkspaceState() {
            return workspaceState;
        }

        @Override
        public final Builder workspaceState(String workspaceState) {
            this.workspaceState = workspaceState;
            return this;
        }

        @Override
        public final Builder workspaceState(TargetWorkspaceState workspaceState) {
            this.workspaceState(workspaceState == null ? null : workspaceState.toString());
            return this;
        }

        public final void setWorkspaceState(String workspaceState) {
            this.workspaceState = workspaceState;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyWorkspaceStateRequest build() {
            return new ModifyWorkspaceStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
