/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyWorkspaceAccessPropertiesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyWorkspaceAccessPropertiesRequest.Builder, ModifyWorkspaceAccessPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyWorkspaceAccessPropertiesRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<WorkspaceAccessProperties> WORKSPACE_ACCESS_PROPERTIES_FIELD = SdkField
            .<WorkspaceAccessProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyWorkspaceAccessPropertiesRequest::workspaceAccessProperties))
            .setter(setter(Builder::workspaceAccessProperties)).constructor(WorkspaceAccessProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceAccessProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            WORKSPACE_ACCESS_PROPERTIES_FIELD));

    private final String resourceId;

    private final WorkspaceAccessProperties workspaceAccessProperties;

    private ModifyWorkspaceAccessPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.workspaceAccessProperties = builder.workspaceAccessProperties;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The device types and operating systems to enable or disable for access.
     * </p>
     * 
     * @return The device types and operating systems to enable or disable for access.
     */
    public WorkspaceAccessProperties workspaceAccessProperties() {
        return workspaceAccessProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceAccessProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyWorkspaceAccessPropertiesRequest)) {
            return false;
        }
        ModifyWorkspaceAccessPropertiesRequest other = (ModifyWorkspaceAccessPropertiesRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(workspaceAccessProperties(), other.workspaceAccessProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyWorkspaceAccessPropertiesRequest").add("ResourceId", resourceId())
                .add("WorkspaceAccessProperties", workspaceAccessProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "WorkspaceAccessProperties":
            return Optional.ofNullable(clazz.cast(workspaceAccessProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyWorkspaceAccessPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyWorkspaceAccessPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyWorkspaceAccessPropertiesRequest> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The device types and operating systems to enable or disable for access.
         * </p>
         * 
         * @param workspaceAccessProperties
         *        The device types and operating systems to enable or disable for access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceAccessProperties(WorkspaceAccessProperties workspaceAccessProperties);

        /**
         * <p>
         * The device types and operating systems to enable or disable for access.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkspaceAccessProperties.Builder} avoiding the
         * need to create one manually via {@link WorkspaceAccessProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkspaceAccessProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #workspaceAccessProperties(WorkspaceAccessProperties)}.
         * 
         * @param workspaceAccessProperties
         *        a consumer that will call methods on {@link WorkspaceAccessProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceAccessProperties(WorkspaceAccessProperties)
         */
        default Builder workspaceAccessProperties(Consumer<WorkspaceAccessProperties.Builder> workspaceAccessProperties) {
            return workspaceAccessProperties(WorkspaceAccessProperties.builder().applyMutation(workspaceAccessProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private WorkspaceAccessProperties workspaceAccessProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyWorkspaceAccessPropertiesRequest model) {
            super(model);
            resourceId(model.resourceId);
            workspaceAccessProperties(model.workspaceAccessProperties);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final WorkspaceAccessProperties.Builder getWorkspaceAccessProperties() {
            return workspaceAccessProperties != null ? workspaceAccessProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceAccessProperties(WorkspaceAccessProperties workspaceAccessProperties) {
            this.workspaceAccessProperties = workspaceAccessProperties;
            return this;
        }

        public final void setWorkspaceAccessProperties(WorkspaceAccessProperties.BuilderImpl workspaceAccessProperties) {
            this.workspaceAccessProperties = workspaceAccessProperties != null ? workspaceAccessProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyWorkspaceAccessPropertiesRequest build() {
            return new ModifyWorkspaceAccessPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
