/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportWorkspaceImageRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ImportWorkspaceImageRequest.Builder, ImportWorkspaceImageRequest> {
    private static final SdkField<String> EC2_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportWorkspaceImageRequest::ec2ImageId)).setter(setter(Builder::ec2ImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2ImageId").build()).build();

    private static final SdkField<String> INGESTION_PROCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportWorkspaceImageRequest::ingestionProcessAsString)).setter(setter(Builder::ingestionProcess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionProcess").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportWorkspaceImageRequest::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportWorkspaceImageRequest::imageDescription)).setter(setter(Builder::imageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDescription").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ImportWorkspaceImageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_IMAGE_ID_FIELD,
            INGESTION_PROCESS_FIELD, IMAGE_NAME_FIELD, IMAGE_DESCRIPTION_FIELD, TAGS_FIELD));

    private final String ec2ImageId;

    private final String ingestionProcess;

    private final String imageName;

    private final String imageDescription;

    private final List<Tag> tags;

    private ImportWorkspaceImageRequest(BuilderImpl builder) {
        super(builder);
        this.ec2ImageId = builder.ec2ImageId;
        this.ingestionProcess = builder.ingestionProcess;
        this.imageName = builder.imageName;
        this.imageDescription = builder.imageDescription;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the EC2 image.
     * </p>
     * 
     * @return The identifier of the EC2 image.
     */
    public String ec2ImageId() {
        return ec2ImageId;
    }

    /**
     * <p>
     * The ingestion process to be used when importing the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionProcess}
     * will return {@link WorkspaceImageIngestionProcess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #ingestionProcessAsString}.
     * </p>
     * 
     * @return The ingestion process to be used when importing the image.
     * @see WorkspaceImageIngestionProcess
     */
    public WorkspaceImageIngestionProcess ingestionProcess() {
        return WorkspaceImageIngestionProcess.fromValue(ingestionProcess);
    }

    /**
     * <p>
     * The ingestion process to be used when importing the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionProcess}
     * will return {@link WorkspaceImageIngestionProcess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #ingestionProcessAsString}.
     * </p>
     * 
     * @return The ingestion process to be used when importing the image.
     * @see WorkspaceImageIngestionProcess
     */
    public String ingestionProcessAsString() {
        return ingestionProcess;
    }

    /**
     * <p>
     * The name of the WorkSpace image.
     * </p>
     * 
     * @return The name of the WorkSpace image.
     */
    public String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The description of the WorkSpace image.
     * </p>
     * 
     * @return The description of the WorkSpace image.
     */
    public String imageDescription() {
        return imageDescription;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags. Each WorkSpaces resource can have a maximum of 50 tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ec2ImageId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionProcessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportWorkspaceImageRequest)) {
            return false;
        }
        ImportWorkspaceImageRequest other = (ImportWorkspaceImageRequest) obj;
        return Objects.equals(ec2ImageId(), other.ec2ImageId())
                && Objects.equals(ingestionProcessAsString(), other.ingestionProcessAsString())
                && Objects.equals(imageName(), other.imageName()) && Objects.equals(imageDescription(), other.imageDescription())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportWorkspaceImageRequest").add("Ec2ImageId", ec2ImageId())
                .add("IngestionProcess", ingestionProcessAsString()).add("ImageName", imageName())
                .add("ImageDescription", imageDescription()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ec2ImageId":
            return Optional.ofNullable(clazz.cast(ec2ImageId()));
        case "IngestionProcess":
            return Optional.ofNullable(clazz.cast(ingestionProcessAsString()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageDescription":
            return Optional.ofNullable(clazz.cast(imageDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportWorkspaceImageRequest, T> g) {
        return obj -> g.apply((ImportWorkspaceImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportWorkspaceImageRequest> {
        /**
         * <p>
         * The identifier of the EC2 image.
         * </p>
         * 
         * @param ec2ImageId
         *        The identifier of the EC2 image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ImageId(String ec2ImageId);

        /**
         * <p>
         * The ingestion process to be used when importing the image.
         * </p>
         * 
         * @param ingestionProcess
         *        The ingestion process to be used when importing the image.
         * @see WorkspaceImageIngestionProcess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceImageIngestionProcess
         */
        Builder ingestionProcess(String ingestionProcess);

        /**
         * <p>
         * The ingestion process to be used when importing the image.
         * </p>
         * 
         * @param ingestionProcess
         *        The ingestion process to be used when importing the image.
         * @see WorkspaceImageIngestionProcess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceImageIngestionProcess
         */
        Builder ingestionProcess(WorkspaceImageIngestionProcess ingestionProcess);

        /**
         * <p>
         * The name of the WorkSpace image.
         * </p>
         * 
         * @param imageName
         *        The name of the WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The description of the WorkSpace image.
         * </p>
         * 
         * @param imageDescription
         *        The description of the WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDescription(String imageDescription);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String ec2ImageId;

        private String ingestionProcess;

        private String imageName;

        private String imageDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportWorkspaceImageRequest model) {
            super(model);
            ec2ImageId(model.ec2ImageId);
            ingestionProcess(model.ingestionProcess);
            imageName(model.imageName);
            imageDescription(model.imageDescription);
            tags(model.tags);
        }

        public final String getEc2ImageId() {
            return ec2ImageId;
        }

        @Override
        public final Builder ec2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
            return this;
        }

        public final void setEc2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
        }

        public final String getIngestionProcess() {
            return ingestionProcess;
        }

        @Override
        public final Builder ingestionProcess(String ingestionProcess) {
            this.ingestionProcess = ingestionProcess;
            return this;
        }

        @Override
        public final Builder ingestionProcess(WorkspaceImageIngestionProcess ingestionProcess) {
            this.ingestionProcess(ingestionProcess == null ? null : ingestionProcess.toString());
            return this;
        }

        public final void setIngestionProcess(String ingestionProcess) {
            this.ingestionProcess = ingestionProcess;
        }

        public final String getImageName() {
            return imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageDescription() {
            return imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportWorkspaceImageRequest build() {
            return new ImportWorkspaceImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
