/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a WorkSpace that cannot be created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedCreateWorkspaceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedCreateWorkspaceRequest.Builder, FailedCreateWorkspaceRequest> {
    private static final SdkField<WorkspaceRequest> WORKSPACE_REQUEST_FIELD = SdkField
            .<WorkspaceRequest> builder(MarshallingType.SDK_POJO).getter(getter(FailedCreateWorkspaceRequest::workspaceRequest))
            .setter(setter(Builder::workspaceRequest)).constructor(WorkspaceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceRequest").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FailedCreateWorkspaceRequest::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FailedCreateWorkspaceRequest::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_REQUEST_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final WorkspaceRequest workspaceRequest;

    private final String errorCode;

    private final String errorMessage;

    private FailedCreateWorkspaceRequest(BuilderImpl builder) {
        this.workspaceRequest = builder.workspaceRequest;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Information about the WorkSpace.
     * </p>
     * 
     * @return Information about the WorkSpace.
     */
    public WorkspaceRequest workspaceRequest() {
        return workspaceRequest;
    }

    /**
     * <p>
     * The error code that is returned if the WorkSpace cannot be created.
     * </p>
     * 
     * @return The error code that is returned if the WorkSpace cannot be created.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The text of the error message that is returned if the WorkSpace cannot be created.
     * </p>
     * 
     * @return The text of the error message that is returned if the WorkSpace cannot be created.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workspaceRequest());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateWorkspaceRequest)) {
            return false;
        }
        FailedCreateWorkspaceRequest other = (FailedCreateWorkspaceRequest) obj;
        return Objects.equals(workspaceRequest(), other.workspaceRequest()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FailedCreateWorkspaceRequest").add("WorkspaceRequest", workspaceRequest())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceRequest":
            return Optional.ofNullable(clazz.cast(workspaceRequest()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedCreateWorkspaceRequest, T> g) {
        return obj -> g.apply((FailedCreateWorkspaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedCreateWorkspaceRequest> {
        /**
         * <p>
         * Information about the WorkSpace.
         * </p>
         * 
         * @param workspaceRequest
         *        Information about the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceRequest(WorkspaceRequest workspaceRequest);

        /**
         * <p>
         * Information about the WorkSpace.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkspaceRequest.Builder} avoiding the need to
         * create one manually via {@link WorkspaceRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkspaceRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #workspaceRequest(WorkspaceRequest)}.
         * 
         * @param workspaceRequest
         *        a consumer that will call methods on {@link WorkspaceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceRequest(WorkspaceRequest)
         */
        default Builder workspaceRequest(Consumer<WorkspaceRequest.Builder> workspaceRequest) {
            return workspaceRequest(WorkspaceRequest.builder().applyMutation(workspaceRequest).build());
        }

        /**
         * <p>
         * The error code that is returned if the WorkSpace cannot be created.
         * </p>
         * 
         * @param errorCode
         *        The error code that is returned if the WorkSpace cannot be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The text of the error message that is returned if the WorkSpace cannot be created.
         * </p>
         * 
         * @param errorMessage
         *        The text of the error message that is returned if the WorkSpace cannot be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private WorkspaceRequest workspaceRequest;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateWorkspaceRequest model) {
            workspaceRequest(model.workspaceRequest);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final WorkspaceRequest.Builder getWorkspaceRequest() {
            return workspaceRequest != null ? workspaceRequest.toBuilder() : null;
        }

        @Override
        public final Builder workspaceRequest(WorkspaceRequest workspaceRequest) {
            this.workspaceRequest = workspaceRequest;
            return this;
        }

        public final void setWorkspaceRequest(WorkspaceRequest.BuilderImpl workspaceRequest) {
            this.workspaceRequest = workspaceRequest != null ? workspaceRequest.build() : null;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public FailedCreateWorkspaceRequest build() {
            return new FailedCreateWorkspaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
