/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspacesConnectionStatusResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeWorkspacesConnectionStatusResponse.Builder, DescribeWorkspacesConnectionStatusResponse> {
    private static final SdkField<List<WorkspaceConnectionStatus>> WORKSPACES_CONNECTION_STATUS_FIELD = SdkField
            .<List<WorkspaceConnectionStatus>> builder(MarshallingType.LIST)
            .getter(getter(DescribeWorkspacesConnectionStatusResponse::workspacesConnectionStatus))
            .setter(setter(Builder::workspacesConnectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspacesConnectionStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceConnectionStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceConnectionStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeWorkspacesConnectionStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WORKSPACES_CONNECTION_STATUS_FIELD, NEXT_TOKEN_FIELD));

    private final List<WorkspaceConnectionStatus> workspacesConnectionStatus;

    private final String nextToken;

    private DescribeWorkspacesConnectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.workspacesConnectionStatus = builder.workspacesConnectionStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the WorkspacesConnectionStatus property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasWorkspacesConnectionStatus() {
        return workspacesConnectionStatus != null && !(workspacesConnectionStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the connection status of the WorkSpace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorkspacesConnectionStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the connection status of the WorkSpace.
     */
    public List<WorkspaceConnectionStatus> workspacesConnectionStatus() {
        return workspacesConnectionStatus;
    }

    /**
     * <p>
     * The token to use to retrieve the next set of results, or null if no more results are available.
     * </p>
     * 
     * @return The token to use to retrieve the next set of results, or null if no more results are available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspacesConnectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesConnectionStatusResponse)) {
            return false;
        }
        DescribeWorkspacesConnectionStatusResponse other = (DescribeWorkspacesConnectionStatusResponse) obj;
        return Objects.equals(workspacesConnectionStatus(), other.workspacesConnectionStatus())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeWorkspacesConnectionStatusResponse")
                .add("WorkspacesConnectionStatus", workspacesConnectionStatus()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspacesConnectionStatus":
            return Optional.ofNullable(clazz.cast(workspacesConnectionStatus()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesConnectionStatusResponse, T> g) {
        return obj -> g.apply((DescribeWorkspacesConnectionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspacesConnectionStatusResponse> {
        /**
         * <p>
         * Information about the connection status of the WorkSpace.
         * </p>
         * 
         * @param workspacesConnectionStatus
         *        Information about the connection status of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspacesConnectionStatus(Collection<WorkspaceConnectionStatus> workspacesConnectionStatus);

        /**
         * <p>
         * Information about the connection status of the WorkSpace.
         * </p>
         * 
         * @param workspacesConnectionStatus
         *        Information about the connection status of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspacesConnectionStatus(WorkspaceConnectionStatus... workspacesConnectionStatus);

        /**
         * <p>
         * Information about the connection status of the WorkSpace.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkspaceConnectionStatus>.Builder}
         * avoiding the need to create one manually via {@link List<WorkspaceConnectionStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkspaceConnectionStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #workspacesConnectionStatus(List<WorkspaceConnectionStatus>)}.
         * 
         * @param workspacesConnectionStatus
         *        a consumer that will call methods on {@link List<WorkspaceConnectionStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspacesConnectionStatus(List<WorkspaceConnectionStatus>)
         */
        Builder workspacesConnectionStatus(Consumer<WorkspaceConnectionStatus.Builder>... workspacesConnectionStatus);

        /**
         * <p>
         * The token to use to retrieve the next set of results, or null if no more results are available.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next set of results, or null if no more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<WorkspaceConnectionStatus> workspacesConnectionStatus = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesConnectionStatusResponse model) {
            super(model);
            workspacesConnectionStatus(model.workspacesConnectionStatus);
            nextToken(model.nextToken);
        }

        public final Collection<WorkspaceConnectionStatus.Builder> getWorkspacesConnectionStatus() {
            return workspacesConnectionStatus != null ? workspacesConnectionStatus.stream()
                    .map(WorkspaceConnectionStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workspacesConnectionStatus(Collection<WorkspaceConnectionStatus> workspacesConnectionStatus) {
            this.workspacesConnectionStatus = WorkspaceConnectionStatusListCopier.copy(workspacesConnectionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesConnectionStatus(WorkspaceConnectionStatus... workspacesConnectionStatus) {
            workspacesConnectionStatus(Arrays.asList(workspacesConnectionStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesConnectionStatus(Consumer<WorkspaceConnectionStatus.Builder>... workspacesConnectionStatus) {
            workspacesConnectionStatus(Stream.of(workspacesConnectionStatus)
                    .map(c -> WorkspaceConnectionStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkspacesConnectionStatus(
                Collection<WorkspaceConnectionStatus.BuilderImpl> workspacesConnectionStatus) {
            this.workspacesConnectionStatus = WorkspaceConnectionStatusListCopier.copyFromBuilder(workspacesConnectionStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeWorkspacesConnectionStatusResponse build() {
            return new DescribeWorkspacesConnectionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
