/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceDirectoriesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspaceDirectoriesRequest.Builder, DescribeWorkspaceDirectoriesRequest> {
    private static final SdkField<List<String>> DIRECTORY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeWorkspaceDirectoriesRequest::directoryIds))
            .setter(setter(Builder::directoryIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeWorkspaceDirectoriesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeWorkspaceDirectoriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_IDS_FIELD,
            LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> directoryIds;

    private final Integer limit;

    private final String nextToken;

    private DescribeWorkspaceDirectoriesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryIds = builder.directoryIds;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DirectoryIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDirectoryIds() {
        return directoryIds != null && !(directoryIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the directories. If the value is null, all directories are retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDirectoryIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the directories. If the value is null, all directories are retrieved.
     */
    public List<String> directoryIds() {
        return directoryIds;
    }

    /**
     * <p>
     * The maximum number of directories to return.
     * </p>
     * 
     * @return The maximum number of directories to return.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryIds());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceDirectoriesRequest)) {
            return false;
        }
        DescribeWorkspaceDirectoriesRequest other = (DescribeWorkspaceDirectoriesRequest) obj;
        return Objects.equals(directoryIds(), other.directoryIds()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeWorkspaceDirectoriesRequest").add("DirectoryIds", directoryIds()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryIds":
            return Optional.ofNullable(clazz.cast(directoryIds()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceDirectoriesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceDirectoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceDirectoriesRequest> {
        /**
         * <p>
         * The identifiers of the directories. If the value is null, all directories are retrieved.
         * </p>
         * 
         * @param directoryIds
         *        The identifiers of the directories. If the value is null, all directories are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryIds(Collection<String> directoryIds);

        /**
         * <p>
         * The identifiers of the directories. If the value is null, all directories are retrieved.
         * </p>
         * 
         * @param directoryIds
         *        The identifiers of the directories. If the value is null, all directories are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryIds(String... directoryIds);

        /**
         * <p>
         * The maximum number of directories to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of directories to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> directoryIds = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceDirectoriesRequest model) {
            super(model);
            directoryIds(model.directoryIds);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final Collection<String> getDirectoryIds() {
            return directoryIds;
        }

        @Override
        public final Builder directoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryIds(String... directoryIds) {
            directoryIds(Arrays.asList(directoryIds));
            return this;
        }

        public final void setDirectoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceDirectoriesRequest build() {
            return new DescribeWorkspaceDirectoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
