/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterValuesException;
import software.amazon.awssdk.services.workspaces.model.InvalidResourceStateException;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.OperationInProgressException;
import software.amazon.awssdk.services.workspaces.model.OperationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.workspaces.model.ResourceAssociatedException;
import software.amazon.awssdk.services.workspaces.model.ResourceCreationFailedException;
import software.amazon.awssdk.services.workspaces.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.workspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspaces.model.ResourceUnavailableException;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UnsupportedNetworkConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesException;
import software.amazon.awssdk.services.workspaces.model.WorkspacesDefaultRoleNotFoundException;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable;

/**
 * Service client for accessing Amazon WorkSpaces. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon WorkSpaces Service</fullname>
 * <p>
 * Amazon WorkSpaces enables you to provision virtual, cloud-based Microsoft Windows and Amazon Linux desktops for your
 * users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface WorkSpacesClient extends SdkClient {
    String SERVICE_NAME = "workspaces";

    /**
     * Create a {@link WorkSpacesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkSpacesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkSpacesClient}.
     */
    static WorkSpacesClientBuilder builder() {
        return new DefaultWorkSpacesClientBuilder();
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     *
     * @param associateIpGroupsRequest
     * @return Result of the AssociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateIpGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateIpGroupsResponse associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIpGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateIpGroupsRequest#builder()}
     * </p>
     *
     * @param associateIpGroupsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateIpGroupsRequest.Builder} to create a request.
     * @return Result of the AssociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateIpGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateIpGroupsResponse associateIpGroups(Consumer<AssociateIpGroupsRequest.Builder> associateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return associateIpGroups(AssociateIpGroupsRequest.builder().applyMutation(associateIpGroupsRequest).build());
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     *
     * @param authorizeIpRulesRequest
     * @return Result of the AuthorizeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AuthorizeIpRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    default AuthorizeIpRulesResponse authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeIpRulesRequest.Builder} avoiding the need
     * to create one manually via {@link AuthorizeIpRulesRequest#builder()}
     * </p>
     *
     * @param authorizeIpRulesRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeIpRulesRequest.Builder} to create a request.
     * @return Result of the AuthorizeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AuthorizeIpRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    default AuthorizeIpRulesResponse authorizeIpRules(Consumer<AuthorizeIpRulesRequest.Builder> authorizeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return authorizeIpRules(AuthorizeIpRulesRequest.builder().applyMutation(authorizeIpRulesRequest).build());
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region.
     * </p>
     *
     * @param copyWorkspaceImageRequest
     * @return Result of the CopyWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CopyWorkspaceImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyWorkspaceImageResponse copyWorkspaceImage(CopyWorkspaceImageRequest copyWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link CopyWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param copyWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on {@link CopyWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return Result of the CopyWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CopyWorkspaceImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyWorkspaceImageResponse copyWorkspaceImage(Consumer<CopyWorkspaceImageRequest.Builder> copyWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return copyWorkspaceImage(CopyWorkspaceImageRequest.builder().applyMutation(copyWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     *
     * @param createIpGroupRequest
     * @return Result of the CreateIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateIpGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpGroupResponse createIpGroup(CreateIpGroupRequest createIpGroupRequest)
            throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceAlreadyExistsException,
            ResourceCreationFailedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpGroupRequest#builder()}
     * </p>
     *
     * @param createIpGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateIpGroupRequest.Builder} to create a request.
     * @return Result of the CreateIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateIpGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpGroupResponse createIpGroup(Consumer<CreateIpGroupRequest.Builder> createIpGroupRequest)
            throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceAlreadyExistsException,
            ResourceCreationFailedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return createIpGroup(CreateIpGroupRequest.builder().applyMutation(createIpGroupRequest).build());
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request.
     * @return Result of the CreateTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest)
            throws ResourceNotFoundException, InvalidParameterValuesException, ResourceLimitExceededException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     *
     * @param createWorkspacesRequest
     * @return Result of the CreateWorkspaces operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorkspacesResponse createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest)
            throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspacesRequest#builder()}
     * </p>
     *
     * @param createWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkspacesRequest.Builder} to create a request.
     * @return Result of the CreateWorkspaces operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorkspacesResponse createWorkspaces(Consumer<CreateWorkspacesRequest.Builder> createWorkspacesRequest)
            throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return createWorkspaces(CreateWorkspacesRequest.builder().applyMutation(createWorkspacesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     *
     * @param deleteIpGroupRequest
     * @return Result of the DeleteIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteIpGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpGroupResponse deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpGroupRequest#builder()}
     * </p>
     *
     * @param deleteIpGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIpGroupRequest.Builder} to create a request.
     * @return Result of the DeleteIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteIpGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpGroupResponse deleteIpGroup(Consumer<DeleteIpGroupRequest.Builder> deleteIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return deleteIpGroup(DeleteIpGroupRequest.builder().applyMutation(deleteIpGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest)
            throws ResourceNotFoundException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and un-share the image if it is shared with other accounts.
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     * @return Result of the DeleteWorkspaceImage operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceImageResponse deleteWorkspaceImage(DeleteWorkspaceImageRequest deleteWorkspaceImageRequest)
            throws ResourceAssociatedException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and un-share the image if it is shared with other accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkspaceImage operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceImageResponse deleteWorkspaceImage(
            Consumer<DeleteWorkspaceImageRequest.Builder> deleteWorkspaceImageRequest) throws ResourceAssociatedException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return deleteWorkspaceImage(DeleteWorkspaceImageRequest.builder().applyMutation(deleteWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     *
     * @param deregisterWorkspaceDirectoryRequest
     * @return Result of the DeregisterWorkspaceDirectory operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeregisterWorkspaceDirectory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(
            DeregisterWorkspaceDirectoryRequest deregisterWorkspaceDirectoryRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterWorkspaceDirectoryRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterWorkspaceDirectoryRequest#builder()}
     * </p>
     *
     * @param deregisterWorkspaceDirectoryRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterWorkspaceDirectoryRequest.Builder} to create
     *        a request.
     * @return Result of the DeregisterWorkspaceDirectory operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeregisterWorkspaceDirectory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(
            Consumer<DeregisterWorkspaceDirectoryRequest.Builder> deregisterWorkspaceDirectoryRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return deregisterWorkspaceDirectory(DeregisterWorkspaceDirectoryRequest.builder()
                .applyMutation(deregisterWorkspaceDirectoryRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param describeAccountRequest
     * @return Result of the DescribeAccount operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAccountRequest#builder()}
     * </p>
     *
     * @param describeAccountRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountRequest.Builder} to create a request.
     * @return Result of the DescribeAccount operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAccountResponse describeAccount(Consumer<DescribeAccountRequest.Builder> describeAccountRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeAccount(DescribeAccountRequest.builder().applyMutation(describeAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     *
     * @param describeAccountModificationsRequest
     * @return Result of the DescribeAccountModifications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccountModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountModificationsResponse describeAccountModifications(
            DescribeAccountModificationsRequest describeAccountModificationsRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountModificationsRequest#builder()}
     * </p>
     *
     * @param describeAccountModificationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountModificationsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeAccountModifications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccountModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountModificationsResponse describeAccountModifications(
            Consumer<DescribeAccountModificationsRequest.Builder> describeAccountModificationsRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeAccountModifications(DescribeAccountModificationsRequest.builder()
                .applyMutation(describeAccountModificationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param describeClientPropertiesRequest
     * @return Result of the DescribeClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientPropertiesResponse describeClientProperties(
            DescribeClientPropertiesRequest describeClientPropertiesRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClientPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClientPropertiesRequest#builder()}
     * </p>
     *
     * @param describeClientPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClientPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientPropertiesResponse describeClientProperties(
            Consumer<DescribeClientPropertiesRequest.Builder> describeClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeClientProperties(DescribeClientPropertiesRequest.builder().applyMutation(describeClientPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see #describeIpGroups(DescribeIpGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIpGroupsResponse describeIpGroups() throws InvalidParameterValuesException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeIpGroups(DescribeIpGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @param describeIpGroupsRequest
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIpGroupsResponse describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIpGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeIpGroupsRequest#builder()}
     * </p>
     *
     * @param describeIpGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIpGroupsRequest.Builder} to create a request.
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIpGroupsResponse describeIpGroups(Consumer<DescribeIpGroupsRequest.Builder> describeIpGroupsRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return describeIpGroups(DescribeIpGroupsRequest.builder().applyMutation(describeIpGroupsRequest).build());
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsRequest.Builder} to create a request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see #describeWorkspaceBundles(DescribeWorkspaceBundlesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesResponse describeWorkspaceBundles() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundles(DescribeWorkspaceBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesResponse describeWorkspaceBundles(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceBundlesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceBundlesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceBundlesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesResponse describeWorkspaceBundles(
            Consumer<DescribeWorkspaceBundlesRequest.Builder> describeWorkspaceBundlesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundles(DescribeWorkspaceBundlesRequest.builder().applyMutation(describeWorkspaceBundlesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client
     *             .describeWorkspaceBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see #describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client
     *             .describeWorkspaceBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client
     *             .describeWorkspaceBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceBundlesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceBundlesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceBundlesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator(
            Consumer<DescribeWorkspaceBundlesRequest.Builder> describeWorkspaceBundlesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest.builder()
                .applyMutation(describeWorkspaceBundlesRequest).build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see #describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceDirectoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceDirectoriesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(
            Consumer<DescribeWorkspaceDirectoriesRequest.Builder> describeWorkspaceDirectoriesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest.builder()
                .applyMutation(describeWorkspaceDirectoriesRequest).build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client
     *             .describeWorkspaceDirectoriesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see #describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator() throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client
     *             .describeWorkspaceDirectoriesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client
     *             .describeWorkspaceDirectoriesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceDirectoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceDirectoriesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator(
            Consumer<DescribeWorkspaceDirectoriesRequest.Builder> describeWorkspaceDirectoriesRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest.builder()
                .applyMutation(describeWorkspaceDirectoriesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see #describeWorkspaceImages(DescribeWorkspaceImagesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagesResponse describeWorkspaceImages() throws AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeWorkspaceImages(DescribeWorkspaceImagesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagesResponse describeWorkspaceImages(DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceImagesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceImagesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceImagesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceImagesResponse describeWorkspaceImages(
            Consumer<DescribeWorkspaceImagesRequest.Builder> describeWorkspaceImagesRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaceImages(DescribeWorkspaceImagesRequest.builder().applyMutation(describeWorkspaceImagesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     * @return Result of the DescribeWorkspaceSnapshots operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(
            DescribeWorkspaceSnapshotsRequest describeWorkspaceSnapshotsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceSnapshotsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkspaceSnapshots operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(
            Consumer<DescribeWorkspaceSnapshotsRequest.Builder> describeWorkspaceSnapshotsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return describeWorkspaceSnapshots(DescribeWorkspaceSnapshotsRequest.builder()
                .applyMutation(describeWorkspaceSnapshotsRequest).build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see #describeWorkspaces(DescribeWorkspacesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesResponse describeWorkspaces() throws InvalidParameterValuesException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspaces(DescribeWorkspacesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesResponse describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesResponse describeWorkspaces(Consumer<DescribeWorkspacesRequest.Builder> describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return describeWorkspaces(DescribeWorkspacesRequest.builder().applyMutation(describeWorkspacesRequest).build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client
     *             .describeWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see #describeWorkspacesPaginator(DescribeWorkspacesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesIterable describeWorkspacesPaginator() throws InvalidParameterValuesException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesPaginator(DescribeWorkspacesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client
     *             .describeWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesIterable describeWorkspacesPaginator(DescribeWorkspacesRequest describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client
     *             .describeWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspacesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesIterable describeWorkspacesPaginator(
            Consumer<DescribeWorkspacesRequest.Builder> describeWorkspacesRequest) throws InvalidParameterValuesException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesPaginator(DescribeWorkspacesRequest.builder().applyMutation(describeWorkspacesRequest).build());
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see #describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus()
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest.builder().build());
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(
            DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesConnectionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspacesConnectionStatusRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspacesConnectionStatusRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(
            Consumer<DescribeWorkspacesConnectionStatusRequest.Builder> describeWorkspacesConnectionStatusRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest.builder()
                .applyMutation(describeWorkspacesConnectionStatusRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     *
     * @param disassociateIpGroupsRequest
     * @return Result of the DisassociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateIpGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIpGroupsResponse disassociateIpGroups(DisassociateIpGroupsRequest disassociateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateIpGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateIpGroupsRequest#builder()}
     * </p>
     *
     * @param disassociateIpGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateIpGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateIpGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIpGroupsResponse disassociateIpGroups(
            Consumer<DisassociateIpGroupsRequest.Builder> disassociateIpGroupsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return disassociateIpGroups(DisassociateIpGroupsRequest.builder().applyMutation(disassociateIpGroupsRequest).build());
    }

    /**
     * <p>
     * Imports the specified Windows 7 or Windows 10 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The
     * image must be an already licensed EC2 image that is in your AWS account, and you must own the image.
     * </p>
     *
     * @param importWorkspaceImageRequest
     * @return Result of the ImportWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportWorkspaceImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportWorkspaceImageResponse importWorkspaceImage(ImportWorkspaceImageRequest importWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the specified Windows 7 or Windows 10 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The
     * image must be an already licensed EC2 image that is in your AWS account, and you must own the image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link ImportWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param importWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on {@link ImportWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return Result of the ImportWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportWorkspaceImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportWorkspaceImageResponse importWorkspaceImage(
            Consumer<ImportWorkspaceImageRequest.Builder> importWorkspaceImageRequest) throws ResourceLimitExceededException,
            ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException, AccessDeniedException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return importWorkspaceImage(ImportWorkspaceImageRequest.builder().applyMutation(importWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     * @return Result of the ListAvailableManagementCidrRanges operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAvailableManagementCidrRanges
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(
            ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableManagementCidrRangesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableManagementCidrRangesRequest#builder()}
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableManagementCidrRangesRequest.Builder} to
     *        create a request.
     * @return Result of the ListAvailableManagementCidrRanges operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAvailableManagementCidrRanges
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(
            Consumer<ListAvailableManagementCidrRangesRequest.Builder> listAvailableManagementCidrRangesRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest.builder()
                .applyMutation(listAvailableManagementCidrRangesRequest).build());
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     *
     * @param migrateWorkspaceRequest
     * @return Result of the MigrateWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.MigrateWorkspace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default MigrateWorkspaceResponse migrateWorkspace(MigrateWorkspaceRequest migrateWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MigrateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link MigrateWorkspaceRequest#builder()}
     * </p>
     *
     * @param migrateWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link MigrateWorkspaceRequest.Builder} to create a request.
     * @return Result of the MigrateWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.MigrateWorkspace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default MigrateWorkspaceResponse migrateWorkspace(Consumer<MigrateWorkspaceRequest.Builder> migrateWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return migrateWorkspace(MigrateWorkspaceRequest.builder().applyMutation(migrateWorkspaceRequest).build());
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param modifyAccountRequest
     * @return Result of the ModifyAccount operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyAccountResponse modifyAccount(ModifyAccountRequest modifyAccountRequest)
            throws InvalidParameterValuesException, AccessDeniedException, InvalidResourceStateException,
            ResourceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyAccountRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyAccountRequest#builder()}
     * </p>
     *
     * @param modifyAccountRequest
     *        A {@link Consumer} that will call methods on {@link ModifyAccountRequest.Builder} to create a request.
     * @return Result of the ModifyAccount operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyAccountResponse modifyAccount(Consumer<ModifyAccountRequest.Builder> modifyAccountRequest)
            throws InvalidParameterValuesException, AccessDeniedException, InvalidResourceStateException,
            ResourceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyAccount(ModifyAccountRequest.builder().applyMutation(modifyAccountRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param modifyClientPropertiesRequest
     * @return Result of the ModifyClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyClientProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClientPropertiesResponse modifyClientProperties(ModifyClientPropertiesRequest modifyClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClientPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyClientPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyClientPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClientPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyClientProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClientPropertiesResponse modifyClientProperties(
            Consumer<ModifyClientPropertiesRequest.Builder> modifyClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return modifyClientProperties(ModifyClientPropertiesRequest.builder().applyMutation(modifyClientPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     * @return Result of the ModifySelfservicePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySelfservicePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySelfservicePermissionsResponse modifySelfservicePermissions(
            ModifySelfservicePermissionsRequest modifySelfservicePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifySelfservicePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ModifySelfservicePermissionsRequest#builder()}
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ModifySelfservicePermissionsRequest.Builder} to create
     *        a request.
     * @return Result of the ModifySelfservicePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySelfservicePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySelfservicePermissionsResponse modifySelfservicePermissions(
            Consumer<ModifySelfservicePermissionsRequest.Builder> modifySelfservicePermissionsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return modifySelfservicePermissions(ModifySelfservicePermissionsRequest.builder()
                .applyMutation(modifySelfservicePermissionsRequest).build());
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     * @return Result of the ModifyWorkspaceAccessProperties operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceAccessProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(
            ModifyWorkspaceAccessPropertiesRequest modifyWorkspaceAccessPropertiesRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceAccessPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyWorkspaceAccessPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ModifyWorkspaceAccessPropertiesRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyWorkspaceAccessProperties operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceAccessProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(
            Consumer<ModifyWorkspaceAccessPropertiesRequest.Builder> modifyWorkspaceAccessPropertiesRequest)
            throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyWorkspaceAccessProperties(ModifyWorkspaceAccessPropertiesRequest.builder()
                .applyMutation(modifyWorkspaceAccessPropertiesRequest).build());
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     * @return Result of the ModifyWorkspaceCreationProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceCreationProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(
            ModifyWorkspaceCreationPropertiesRequest modifyWorkspaceCreationPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceCreationPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyWorkspaceCreationPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ModifyWorkspaceCreationPropertiesRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyWorkspaceCreationProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceCreationProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(
            Consumer<ModifyWorkspaceCreationPropertiesRequest.Builder> modifyWorkspaceCreationPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return modifyWorkspaceCreationProperties(ModifyWorkspaceCreationPropertiesRequest.builder()
                .applyMutation(modifyWorkspaceCreationPropertiesRequest).build());
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties.
     * </p>
     *
     * @param modifyWorkspacePropertiesRequest
     * @return Result of the ModifyWorkspaceProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws UnsupportedWorkspaceConfigurationException
     *         The configuration of this WorkSpace is not supported for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(
            ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, OperationInProgressException, UnsupportedWorkspaceConfigurationException,
            ResourceNotFoundException, AccessDeniedException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspacePropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyWorkspacePropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspacePropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ModifyWorkspacePropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyWorkspaceProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws UnsupportedWorkspaceConfigurationException
     *         The configuration of this WorkSpace is not supported for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(
            Consumer<ModifyWorkspacePropertiesRequest.Builder> modifyWorkspacePropertiesRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, OperationInProgressException,
            UnsupportedWorkspaceConfigurationException, ResourceNotFoundException, AccessDeniedException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        return modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest.builder()
                .applyMutation(modifyWorkspacePropertiesRequest).build());
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     * @return Result of the ModifyWorkspaceState operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceStateResponse modifyWorkspaceState(ModifyWorkspaceStateRequest modifyWorkspaceStateRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceStateRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyWorkspaceStateRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     *        A {@link Consumer} that will call methods on {@link ModifyWorkspaceStateRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyWorkspaceState operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyWorkspaceStateResponse modifyWorkspaceState(
            Consumer<ModifyWorkspaceStateRequest.Builder> modifyWorkspaceStateRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return modifyWorkspaceState(ModifyWorkspaceStateRequest.builder().applyMutation(modifyWorkspaceStateRequest).build());
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code> or <code>UNHEALTHY</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     *
     * @param rebootWorkspacesRequest
     * @return Result of the RebootWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebootWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootWorkspacesResponse rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code> or <code>UNHEALTHY</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link RebootWorkspacesRequest#builder()}
     * </p>
     *
     * @param rebootWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link RebootWorkspacesRequest.Builder} to create a request.
     * @return Result of the RebootWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebootWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootWorkspacesResponse rebootWorkspaces(Consumer<RebootWorkspacesRequest.Builder> rebootWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        return rebootWorkspaces(RebootWorkspacesRequest.builder().applyMutation(rebootWorkspacesRequest).build());
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     *
     * @param rebuildWorkspacesRequest
     * @return Result of the RebuildWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebuildWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebuildWorkspacesResponse rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebuildWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link RebuildWorkspacesRequest#builder()}
     * </p>
     *
     * @param rebuildWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link RebuildWorkspacesRequest.Builder} to create a request.
     * @return Result of the RebuildWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebuildWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default RebuildWorkspacesResponse rebuildWorkspaces(Consumer<RebuildWorkspacesRequest.Builder> rebuildWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        return rebuildWorkspaces(RebuildWorkspacesRequest.builder().applyMutation(rebuildWorkspacesRequest).build());
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     * @return Result of the RegisterWorkspaceDirectory operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws WorkspacesDefaultRoleNotFoundException
     *         The workspaces_DefaultRole role could not be found. If this is the first time you are registering a
     *         directory, you will need to create the workspaces_DefaultRole role before you can register a directory.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws UnsupportedNetworkConfigurationException
     *         The configuration of this network is not supported for this operation, or your network configuration
     *         conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RegisterWorkspaceDirectory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(
            RegisterWorkspaceDirectoryRequest registerWorkspaceDirectoryRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceLimitExceededException, AccessDeniedException,
            WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException, UnsupportedNetworkConfigurationException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterWorkspaceDirectoryRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterWorkspaceDirectoryRequest#builder()}
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     *        A {@link Consumer} that will call methods on {@link RegisterWorkspaceDirectoryRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterWorkspaceDirectory operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws WorkspacesDefaultRoleNotFoundException
     *         The workspaces_DefaultRole role could not be found. If this is the first time you are registering a
     *         directory, you will need to create the workspaces_DefaultRole role before you can register a directory.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws UnsupportedNetworkConfigurationException
     *         The configuration of this network is not supported for this operation, or your network configuration
     *         conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RegisterWorkspaceDirectory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(
            Consumer<RegisterWorkspaceDirectoryRequest.Builder> registerWorkspaceDirectoryRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            AccessDeniedException, WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException,
            UnsupportedNetworkConfigurationException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return registerWorkspaceDirectory(RegisterWorkspaceDirectoryRequest.builder()
                .applyMutation(registerWorkspaceDirectoryRequest).build());
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     *
     * @param restoreWorkspaceRequest
     * @return Result of the RestoreWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RestoreWorkspace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreWorkspaceResponse restoreWorkspace(RestoreWorkspaceRequest restoreWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link RestoreWorkspaceRequest#builder()}
     * </p>
     *
     * @param restoreWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link RestoreWorkspaceRequest.Builder} to create a request.
     * @return Result of the RestoreWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RestoreWorkspace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreWorkspaceResponse restoreWorkspace(Consumer<RestoreWorkspaceRequest.Builder> restoreWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        return restoreWorkspace(RestoreWorkspaceRequest.builder().applyMutation(restoreWorkspaceRequest).build());
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     *
     * @param revokeIpRulesRequest
     * @return Result of the RevokeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RevokeIpRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeIpRulesResponse revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeIpRulesRequest.Builder} avoiding the need to
     * create one manually via {@link RevokeIpRulesRequest#builder()}
     * </p>
     *
     * @param revokeIpRulesRequest
     *        A {@link Consumer} that will call methods on {@link RevokeIpRulesRequest.Builder} to create a request.
     * @return Result of the RevokeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RevokeIpRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeIpRulesResponse revokeIpRules(Consumer<RevokeIpRulesRequest.Builder> revokeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        return revokeIpRules(RevokeIpRulesRequest.builder().applyMutation(revokeIpRulesRequest).build());
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>STOPPED</code>.
     * </p>
     *
     * @param startWorkspacesRequest
     * @return Result of the StartWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default StartWorkspacesResponse startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>STOPPED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link StartWorkspacesRequest#builder()}
     * </p>
     *
     * @param startWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link StartWorkspacesRequest.Builder} to create a request.
     * @return Result of the StartWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default StartWorkspacesResponse startWorkspaces(Consumer<StartWorkspacesRequest.Builder> startWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        return startWorkspaces(StartWorkspacesRequest.builder().applyMutation(startWorkspacesRequest).build());
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     *
     * @param stopWorkspacesRequest
     * @return Result of the StopWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default StopWorkspacesResponse stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link StopWorkspacesRequest#builder()}
     * </p>
     *
     * @param stopWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link StopWorkspacesRequest.Builder} to create a request.
     * @return Result of the StopWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default StopWorkspacesResponse stopWorkspaces(Consumer<StopWorkspacesRequest.Builder> stopWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        return stopWorkspaces(StopWorkspacesRequest.builder().applyMutation(stopWorkspacesRequest).build());
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web Services before terminating the WorkSpace.
     * </p>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated.
     * </p>
     *
     * @param terminateWorkspacesRequest
     * @return Result of the TerminateWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default TerminateWorkspacesResponse terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web Services before terminating the WorkSpace.
     * </p>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link TerminateWorkspacesRequest#builder()}
     * </p>
     *
     * @param terminateWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link TerminateWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the TerminateWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default TerminateWorkspacesResponse terminateWorkspaces(
            Consumer<TerminateWorkspacesRequest.Builder> terminateWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        return terminateWorkspaces(TerminateWorkspacesRequest.builder().applyMutation(terminateWorkspacesRequest).build());
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     * @return Result of the UpdateRulesOfIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateRulesOfIpGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRulesOfIpGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRulesOfIpGroupRequest#builder()}
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRulesOfIpGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRulesOfIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateRulesOfIpGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(
            Consumer<UpdateRulesOfIpGroupRequest.Builder> updateRulesOfIpGroupRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest.builder().applyMutation(updateRulesOfIpGroupRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("workspaces");
    }
}
