/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceProperties.Builder, WorkspaceProperties> {
    private static final SdkField<String> RUNNING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkspaceProperties::runningModeAsString)).setter(setter(Builder::runningMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningMode").build()).build();

    private static final SdkField<Integer> RUNNING_MODE_AUTO_STOP_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WorkspaceProperties::runningModeAutoStopTimeoutInMinutes))
            .setter(setter(Builder::runningModeAutoStopTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RunningModeAutoStopTimeoutInMinutes").build()).build();

    private static final SdkField<Integer> ROOT_VOLUME_SIZE_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WorkspaceProperties::rootVolumeSizeGib)).setter(setter(Builder::rootVolumeSizeGib))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeSizeGib").build()).build();

    private static final SdkField<Integer> USER_VOLUME_SIZE_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WorkspaceProperties::userVolumeSizeGib)).setter(setter(Builder::userVolumeSizeGib))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeSizeGib").build()).build();

    private static final SdkField<String> COMPUTE_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WorkspaceProperties::computeTypeNameAsString)).setter(setter(Builder::computeTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTypeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNNING_MODE_FIELD,
            RUNNING_MODE_AUTO_STOP_TIMEOUT_IN_MINUTES_FIELD, ROOT_VOLUME_SIZE_GIB_FIELD, USER_VOLUME_SIZE_GIB_FIELD,
            COMPUTE_TYPE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String runningMode;

    private final Integer runningModeAutoStopTimeoutInMinutes;

    private final Integer rootVolumeSizeGib;

    private final Integer userVolumeSizeGib;

    private final String computeTypeName;

    private WorkspaceProperties(BuilderImpl builder) {
        this.runningMode = builder.runningMode;
        this.runningModeAutoStopTimeoutInMinutes = builder.runningModeAutoStopTimeoutInMinutes;
        this.rootVolumeSizeGib = builder.rootVolumeSizeGib;
        this.userVolumeSizeGib = builder.userVolumeSizeGib;
        this.computeTypeName = builder.computeTypeName;
    }

    /**
     * <p>
     * The running mode. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace Running
     * Mode</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link RunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The running mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace
     *         Running Mode</a>.
     * @see RunningMode
     */
    public RunningMode runningMode() {
        return RunningMode.fromValue(runningMode);
    }

    /**
     * <p>
     * The running mode. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace Running
     * Mode</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link RunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The running mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace
     *         Running Mode</a>.
     * @see RunningMode
     */
    public String runningModeAsString() {
        return runningMode;
    }

    /**
     * <p>
     * The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
     * </p>
     * 
     * @return The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute
     *         intervals.
     */
    public Integer runningModeAutoStopTimeoutInMinutes() {
        return runningModeAutoStopTimeoutInMinutes;
    }

    /**
     * <p>
     * The size of the root volume.
     * </p>
     * 
     * @return The size of the root volume.
     */
    public Integer rootVolumeSizeGib() {
        return rootVolumeSizeGib;
    }

    /**
     * <p>
     * The size of the user storage.
     * </p>
     * 
     * @return The size of the user storage.
     */
    public Integer userVolumeSizeGib() {
        return userVolumeSizeGib;
    }

    /**
     * <p>
     * The compute type. For more information, see <a
     * href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeTypeName}
     * will return {@link Compute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeNameAsString}.
     * </p>
     * 
     * @return The compute type. For more information, see <a
     *         href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
     * @see Compute
     */
    public Compute computeTypeName() {
        return Compute.fromValue(computeTypeName);
    }

    /**
     * <p>
     * The compute type. For more information, see <a
     * href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeTypeName}
     * will return {@link Compute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeNameAsString}.
     * </p>
     * 
     * @return The compute type. For more information, see <a
     *         href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
     * @see Compute
     */
    public String computeTypeNameAsString() {
        return computeTypeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runningModeAutoStopTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(rootVolumeSizeGib());
        hashCode = 31 * hashCode + Objects.hashCode(userVolumeSizeGib());
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeNameAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceProperties)) {
            return false;
        }
        WorkspaceProperties other = (WorkspaceProperties) obj;
        return Objects.equals(runningModeAsString(), other.runningModeAsString())
                && Objects.equals(runningModeAutoStopTimeoutInMinutes(), other.runningModeAutoStopTimeoutInMinutes())
                && Objects.equals(rootVolumeSizeGib(), other.rootVolumeSizeGib())
                && Objects.equals(userVolumeSizeGib(), other.userVolumeSizeGib())
                && Objects.equals(computeTypeNameAsString(), other.computeTypeNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WorkspaceProperties").add("RunningMode", runningModeAsString())
                .add("RunningModeAutoStopTimeoutInMinutes", runningModeAutoStopTimeoutInMinutes())
                .add("RootVolumeSizeGib", rootVolumeSizeGib()).add("UserVolumeSizeGib", userVolumeSizeGib())
                .add("ComputeTypeName", computeTypeNameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunningMode":
            return Optional.ofNullable(clazz.cast(runningModeAsString()));
        case "RunningModeAutoStopTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(runningModeAutoStopTimeoutInMinutes()));
        case "RootVolumeSizeGib":
            return Optional.ofNullable(clazz.cast(rootVolumeSizeGib()));
        case "UserVolumeSizeGib":
            return Optional.ofNullable(clazz.cast(userVolumeSizeGib()));
        case "ComputeTypeName":
            return Optional.ofNullable(clazz.cast(computeTypeNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceProperties, T> g) {
        return obj -> g.apply((WorkspaceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceProperties> {
        /**
         * <p>
         * The running mode. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace
         * Running Mode</a>.
         * </p>
         * 
         * @param runningMode
         *        The running mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace
         *        Running Mode</a>.
         * @see RunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunningMode
         */
        Builder runningMode(String runningMode);

        /**
         * <p>
         * The running mode. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace
         * Running Mode</a>.
         * </p>
         * 
         * @param runningMode
         *        The running mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace
         *        Running Mode</a>.
         * @see RunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunningMode
         */
        Builder runningMode(RunningMode runningMode);

        /**
         * <p>
         * The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
         * </p>
         * 
         * @param runningModeAutoStopTimeoutInMinutes
         *        The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute
         *        intervals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningModeAutoStopTimeoutInMinutes(Integer runningModeAutoStopTimeoutInMinutes);

        /**
         * <p>
         * The size of the root volume.
         * </p>
         * 
         * @param rootVolumeSizeGib
         *        The size of the root volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootVolumeSizeGib(Integer rootVolumeSizeGib);

        /**
         * <p>
         * The size of the user storage.
         * </p>
         * 
         * @param userVolumeSizeGib
         *        The size of the user storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userVolumeSizeGib(Integer userVolumeSizeGib);

        /**
         * <p>
         * The compute type. For more information, see <a
         * href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
         * </p>
         * 
         * @param computeTypeName
         *        The compute type. For more information, see <a
         *        href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces
         *        Bundles</a>.
         * @see Compute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compute
         */
        Builder computeTypeName(String computeTypeName);

        /**
         * <p>
         * The compute type. For more information, see <a
         * href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
         * </p>
         * 
         * @param computeTypeName
         *        The compute type. For more information, see <a
         *        href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces
         *        Bundles</a>.
         * @see Compute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compute
         */
        Builder computeTypeName(Compute computeTypeName);
    }

    static final class BuilderImpl implements Builder {
        private String runningMode;

        private Integer runningModeAutoStopTimeoutInMinutes;

        private Integer rootVolumeSizeGib;

        private Integer userVolumeSizeGib;

        private String computeTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceProperties model) {
            runningMode(model.runningMode);
            runningModeAutoStopTimeoutInMinutes(model.runningModeAutoStopTimeoutInMinutes);
            rootVolumeSizeGib(model.rootVolumeSizeGib);
            userVolumeSizeGib(model.userVolumeSizeGib);
            computeTypeName(model.computeTypeName);
        }

        public final String getRunningModeAsString() {
            return runningMode;
        }

        @Override
        public final Builder runningMode(String runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        @Override
        public final Builder runningMode(RunningMode runningMode) {
            this.runningMode(runningMode == null ? null : runningMode.toString());
            return this;
        }

        public final void setRunningMode(String runningMode) {
            this.runningMode = runningMode;
        }

        public final Integer getRunningModeAutoStopTimeoutInMinutes() {
            return runningModeAutoStopTimeoutInMinutes;
        }

        @Override
        public final Builder runningModeAutoStopTimeoutInMinutes(Integer runningModeAutoStopTimeoutInMinutes) {
            this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
            return this;
        }

        public final void setRunningModeAutoStopTimeoutInMinutes(Integer runningModeAutoStopTimeoutInMinutes) {
            this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
        }

        public final Integer getRootVolumeSizeGib() {
            return rootVolumeSizeGib;
        }

        @Override
        public final Builder rootVolumeSizeGib(Integer rootVolumeSizeGib) {
            this.rootVolumeSizeGib = rootVolumeSizeGib;
            return this;
        }

        public final void setRootVolumeSizeGib(Integer rootVolumeSizeGib) {
            this.rootVolumeSizeGib = rootVolumeSizeGib;
        }

        public final Integer getUserVolumeSizeGib() {
            return userVolumeSizeGib;
        }

        @Override
        public final Builder userVolumeSizeGib(Integer userVolumeSizeGib) {
            this.userVolumeSizeGib = userVolumeSizeGib;
            return this;
        }

        public final void setUserVolumeSizeGib(Integer userVolumeSizeGib) {
            this.userVolumeSizeGib = userVolumeSizeGib;
        }

        public final String getComputeTypeNameAsString() {
            return computeTypeName;
        }

        @Override
        public final Builder computeTypeName(String computeTypeName) {
            this.computeTypeName = computeTypeName;
            return this;
        }

        @Override
        public final Builder computeTypeName(Compute computeTypeName) {
            this.computeTypeName(computeTypeName == null ? null : computeTypeName.toString());
            return this;
        }

        public final void setComputeTypeName(String computeTypeName) {
            this.computeTypeName = computeTypeName;
        }

        @Override
        public WorkspaceProperties build() {
            return new WorkspaceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
