/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateWorkspacesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<TerminateWorkspacesRequest.Builder, TerminateWorkspacesRequest> {
    private static final SdkField<List<TerminateRequest>> TERMINATE_WORKSPACE_REQUESTS_FIELD = SdkField
            .<List<TerminateRequest>> builder(MarshallingType.LIST)
            .getter(getter(TerminateWorkspacesRequest::terminateWorkspaceRequests))
            .setter(setter(Builder::terminateWorkspaceRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateWorkspaceRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TerminateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(TerminateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TERMINATE_WORKSPACE_REQUESTS_FIELD));

    private final List<TerminateRequest> terminateWorkspaceRequests;

    private TerminateWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.terminateWorkspaceRequests = builder.terminateWorkspaceRequests;
    }

    /**
     * Returns true if the TerminateWorkspaceRequests property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasTerminateWorkspaceRequests() {
        return terminateWorkspaceRequests != null && !(terminateWorkspaceRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTerminateWorkspaceRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
     */
    public List<TerminateRequest> terminateWorkspaceRequests() {
        return terminateWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(terminateWorkspaceRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateWorkspacesRequest)) {
            return false;
        }
        TerminateWorkspacesRequest other = (TerminateWorkspacesRequest) obj;
        return Objects.equals(terminateWorkspaceRequests(), other.terminateWorkspaceRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TerminateWorkspacesRequest").add("TerminateWorkspaceRequests", terminateWorkspaceRequests())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminateWorkspaceRequests":
            return Optional.ofNullable(clazz.cast(terminateWorkspaceRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateWorkspacesRequest, T> g) {
        return obj -> g.apply((TerminateWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, TerminateWorkspacesRequest> {
        /**
         * <p>
         * The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param terminateWorkspaceRequests
         *        The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateWorkspaceRequests(Collection<TerminateRequest> terminateWorkspaceRequests);

        /**
         * <p>
         * The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param terminateWorkspaceRequests
         *        The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateWorkspaceRequests(TerminateRequest... terminateWorkspaceRequests);

        /**
         * <p>
         * The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TerminateRequest>.Builder} avoiding the
         * need to create one manually via {@link List<TerminateRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TerminateRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #terminateWorkspaceRequests(List<TerminateRequest>)}.
         * 
         * @param terminateWorkspaceRequests
         *        a consumer that will call methods on {@link List<TerminateRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminateWorkspaceRequests(List<TerminateRequest>)
         */
        Builder terminateWorkspaceRequests(Consumer<TerminateRequest.Builder>... terminateWorkspaceRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<TerminateRequest> terminateWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateWorkspacesRequest model) {
            super(model);
            terminateWorkspaceRequests(model.terminateWorkspaceRequests);
        }

        public final Collection<TerminateRequest.Builder> getTerminateWorkspaceRequests() {
            return terminateWorkspaceRequests != null ? terminateWorkspaceRequests.stream().map(TerminateRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder terminateWorkspaceRequests(Collection<TerminateRequest> terminateWorkspaceRequests) {
            this.terminateWorkspaceRequests = TerminateWorkspaceRequestsCopier.copy(terminateWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminateWorkspaceRequests(TerminateRequest... terminateWorkspaceRequests) {
            terminateWorkspaceRequests(Arrays.asList(terminateWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminateWorkspaceRequests(Consumer<TerminateRequest.Builder>... terminateWorkspaceRequests) {
            terminateWorkspaceRequests(Stream.of(terminateWorkspaceRequests)
                    .map(c -> TerminateRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTerminateWorkspaceRequests(Collection<TerminateRequest.BuilderImpl> terminateWorkspaceRequests) {
            this.terminateWorkspaceRequests = TerminateWorkspaceRequestsCopier.copyFromBuilder(terminateWorkspaceRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateWorkspacesRequest build() {
            return new TerminateWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
