/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MigrateWorkspaceRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<MigrateWorkspaceRequest.Builder, MigrateWorkspaceRequest> {
    private static final SdkField<String> SOURCE_WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MigrateWorkspaceRequest::sourceWorkspaceId)).setter(setter(Builder::sourceWorkspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceWorkspaceId").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MigrateWorkspaceRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_WORKSPACE_ID_FIELD,
            BUNDLE_ID_FIELD));

    private final String sourceWorkspaceId;

    private final String bundleId;

    private MigrateWorkspaceRequest(BuilderImpl builder) {
        super(builder);
        this.sourceWorkspaceId = builder.sourceWorkspaceId;
        this.bundleId = builder.bundleId;
    }

    /**
     * <p>
     * The identifier of the WorkSpace to migrate from.
     * </p>
     * 
     * @return The identifier of the WorkSpace to migrate from.
     */
    public String sourceWorkspaceId() {
        return sourceWorkspaceId;
    }

    /**
     * <p>
     * The identifier of the target bundle type to migrate the WorkSpace to.
     * </p>
     * 
     * @return The identifier of the target bundle type to migrate the WorkSpace to.
     */
    public String bundleId() {
        return bundleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrateWorkspaceRequest)) {
            return false;
        }
        MigrateWorkspaceRequest other = (MigrateWorkspaceRequest) obj;
        return Objects.equals(sourceWorkspaceId(), other.sourceWorkspaceId()) && Objects.equals(bundleId(), other.bundleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MigrateWorkspaceRequest").add("SourceWorkspaceId", sourceWorkspaceId())
                .add("BundleId", bundleId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceWorkspaceId":
            return Optional.ofNullable(clazz.cast(sourceWorkspaceId()));
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrateWorkspaceRequest, T> g) {
        return obj -> g.apply((MigrateWorkspaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, MigrateWorkspaceRequest> {
        /**
         * <p>
         * The identifier of the WorkSpace to migrate from.
         * </p>
         * 
         * @param sourceWorkspaceId
         *        The identifier of the WorkSpace to migrate from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceWorkspaceId(String sourceWorkspaceId);

        /**
         * <p>
         * The identifier of the target bundle type to migrate the WorkSpace to.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the target bundle type to migrate the WorkSpace to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String sourceWorkspaceId;

        private String bundleId;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrateWorkspaceRequest model) {
            super(model);
            sourceWorkspaceId(model.sourceWorkspaceId);
            bundleId(model.bundleId);
        }

        public final String getSourceWorkspaceId() {
            return sourceWorkspaceId;
        }

        @Override
        public final Builder sourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
            return this;
        }

        public final void setSourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MigrateWorkspaceRequest build() {
            return new MigrateWorkspaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
