/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateIpGroupsRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DisassociateIpGroupsRequest.Builder, DisassociateIpGroupsRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisassociateIpGroupsRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DisassociateIpGroupsRequest::groupIds))
            .setter(setter(Builder::groupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            GROUP_IDS_FIELD));

    private final String directoryId;

    private final List<String> groupIds;

    private DisassociateIpGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.groupIds = builder.groupIds;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * Returns true if the GroupIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroupIds() {
        return groupIds != null && !(groupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of one or more IP access control groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of one or more IP access control groups.
     */
    public List<String> groupIds() {
        return groupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(groupIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateIpGroupsRequest)) {
            return false;
        }
        DisassociateIpGroupsRequest other = (DisassociateIpGroupsRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(groupIds(), other.groupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateIpGroupsRequest").add("DirectoryId", directoryId()).add("GroupIds", groupIds())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "GroupIds":
            return Optional.ofNullable(clazz.cast(groupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateIpGroupsRequest, T> g) {
        return obj -> g.apply((DisassociateIpGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateIpGroupsRequest> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The identifiers of one or more IP access control groups.
         * </p>
         * 
         * @param groupIds
         *        The identifiers of one or more IP access control groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(Collection<String> groupIds);

        /**
         * <p>
         * The identifiers of one or more IP access control groups.
         * </p>
         * 
         * @param groupIds
         *        The identifiers of one or more IP access control groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(String... groupIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> groupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateIpGroupsRequest model) {
            super(model);
            directoryId(model.directoryId);
            groupIds(model.groupIds);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<String> getGroupIds() {
            return groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = IpGroupIdListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = IpGroupIdListCopier.copy(groupIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateIpGroupsRequest build() {
            return new DisassociateIpGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
