/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClientPropertiesResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeClientPropertiesResponse.Builder, DescribeClientPropertiesResponse> {
    private static final SdkField<List<ClientPropertiesResult>> CLIENT_PROPERTIES_LIST_FIELD = SdkField
            .<List<ClientPropertiesResult>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClientPropertiesResponse::clientPropertiesList))
            .setter(setter(Builder::clientPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClientPropertiesResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClientPropertiesResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_PROPERTIES_LIST_FIELD));

    private final List<ClientPropertiesResult> clientPropertiesList;

    private DescribeClientPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.clientPropertiesList = builder.clientPropertiesList;
    }

    /**
     * Returns true if the ClientPropertiesList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasClientPropertiesList() {
        return clientPropertiesList != null && !(clientPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the specified Amazon WorkSpaces clients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClientPropertiesList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the specified Amazon WorkSpaces clients.
     */
    public List<ClientPropertiesResult> clientPropertiesList() {
        return clientPropertiesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientPropertiesList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientPropertiesResponse)) {
            return false;
        }
        DescribeClientPropertiesResponse other = (DescribeClientPropertiesResponse) obj;
        return Objects.equals(clientPropertiesList(), other.clientPropertiesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClientPropertiesResponse").add("ClientPropertiesList", clientPropertiesList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientPropertiesList":
            return Optional.ofNullable(clazz.cast(clientPropertiesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientPropertiesResponse, T> g) {
        return obj -> g.apply((DescribeClientPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClientPropertiesResponse> {
        /**
         * <p>
         * Information about the specified Amazon WorkSpaces clients.
         * </p>
         * 
         * @param clientPropertiesList
         *        Information about the specified Amazon WorkSpaces clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPropertiesList(Collection<ClientPropertiesResult> clientPropertiesList);

        /**
         * <p>
         * Information about the specified Amazon WorkSpaces clients.
         * </p>
         * 
         * @param clientPropertiesList
         *        Information about the specified Amazon WorkSpaces clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPropertiesList(ClientPropertiesResult... clientPropertiesList);

        /**
         * <p>
         * Information about the specified Amazon WorkSpaces clients.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClientPropertiesResult>.Builder} avoiding
         * the need to create one manually via {@link List<ClientPropertiesResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClientPropertiesResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #clientPropertiesList(List<ClientPropertiesResult>)}.
         * 
         * @param clientPropertiesList
         *        a consumer that will call methods on {@link List<ClientPropertiesResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientPropertiesList(List<ClientPropertiesResult>)
         */
        Builder clientPropertiesList(Consumer<ClientPropertiesResult.Builder>... clientPropertiesList);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<ClientPropertiesResult> clientPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientPropertiesResponse model) {
            super(model);
            clientPropertiesList(model.clientPropertiesList);
        }

        public final Collection<ClientPropertiesResult.Builder> getClientPropertiesList() {
            return clientPropertiesList != null ? clientPropertiesList.stream().map(ClientPropertiesResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clientPropertiesList(Collection<ClientPropertiesResult> clientPropertiesList) {
            this.clientPropertiesList = ClientPropertiesListCopier.copy(clientPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientPropertiesList(ClientPropertiesResult... clientPropertiesList) {
            clientPropertiesList(Arrays.asList(clientPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientPropertiesList(Consumer<ClientPropertiesResult.Builder>... clientPropertiesList) {
            clientPropertiesList(Stream.of(clientPropertiesList)
                    .map(c -> ClientPropertiesResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClientPropertiesList(Collection<ClientPropertiesResult.BuilderImpl> clientPropertiesList) {
            this.clientPropertiesList = ClientPropertiesListCopier.copyFromBuilder(clientPropertiesList);
        }

        @Override
        public DescribeClientPropertiesResponse build() {
            return new DescribeClientPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
