/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmailmessageflow;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest;
import software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentResponse;
import software.amazon.awssdk.services.workmailmessageflow.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workmailmessageflow.model.WorkMailMessageFlowException;

/**
 * Service client for accessing Amazon WorkMail Message Flow. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The WorkMail Message Flow API provides access to email messages as they are being sent and received by a WorkMail
 * organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface WorkMailMessageFlowClient extends SdkClient {
    String SERVICE_NAME = "workmailmessageflow";

    /**
     * Create a {@link WorkMailMessageFlowClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkMailMessageFlowClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkMailMessageFlowClient}.
     */
    static WorkMailMessageFlowClientBuilder builder() {
        return new DefaultWorkMailMessageFlowClientBuilder();
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     *
     * @param getRawMessageContentRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        GetRawMessageContentResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The raw content of the email message, in MIME format.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT getRawMessageContent(GetRawMessageContentRequest getRawMessageContentRequest,
            ResponseTransformer<GetRawMessageContentResponse, ReturnT> responseTransformer) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRawMessageContentRequest.Builder} avoiding the
     * need to create one manually via {@link GetRawMessageContentRequest#builder()}
     * </p>
     *
     * @param getRawMessageContentRequest
     *        A {@link Consumer} that will call methods on {@link GetRawMessageContentRequest.Builder} to create a
     *        request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        GetRawMessageContentResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The raw content of the email message, in MIME format.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT getRawMessageContent(Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest,
            ResponseTransformer<GetRawMessageContentResponse, ReturnT> responseTransformer) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return getRawMessageContent(GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest).build(),
                responseTransformer);
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     *
     * @param getRawMessageContentRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The raw content of the email message, in MIME format.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see #getRawMessageContent(GetRawMessageContentRequest, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRawMessageContentResponse getRawMessageContent(GetRawMessageContentRequest getRawMessageContentRequest,
            Path filePath) throws ResourceNotFoundException, AwsServiceException, SdkClientException,
            WorkMailMessageFlowException {
        return getRawMessageContent(getRawMessageContentRequest, ResponseTransformer.toFile(filePath));
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRawMessageContentRequest.Builder} avoiding the
     * need to create one manually via {@link GetRawMessageContentRequest#builder()}
     * </p>
     *
     * @param getRawMessageContentRequest
     *        A {@link Consumer} that will call methods on {@link GetRawMessageContentRequest.Builder} to create a
     *        request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The raw content of the email message, in MIME format.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see #getRawMessageContent(GetRawMessageContentRequest, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRawMessageContentResponse getRawMessageContent(
            Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest, Path filePath)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return getRawMessageContent(GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest).build(),
                filePath);
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     *
     * @param getRawMessageContentRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         The raw content of the email message, in MIME format.
     *         </p>
     *         '.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see #getObject(getRawMessageContent, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<GetRawMessageContentResponse> getRawMessageContent(
            GetRawMessageContentRequest getRawMessageContentRequest) throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkMailMessageFlowException {
        return getRawMessageContent(getRawMessageContentRequest, ResponseTransformer.toInputStream());
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRawMessageContentRequest.Builder} avoiding the
     * need to create one manually via {@link GetRawMessageContentRequest#builder()}
     * </p>
     *
     * @param getRawMessageContentRequest
     *        A {@link Consumer} that will call methods on {@link GetRawMessageContentRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         The raw content of the email message, in MIME format.
     *         </p>
     *         '.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see #getObject(getRawMessageContent, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<GetRawMessageContentResponse> getRawMessageContent(
            Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return getRawMessageContent(GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest).build());
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     *
     * @param getRawMessageContentRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         The raw content of the email message, in MIME format.
     *         </p>
     *         '.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see #getObject(getRawMessageContent, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<GetRawMessageContentResponse> getRawMessageContentAsBytes(
            GetRawMessageContentRequest getRawMessageContentRequest) throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkMailMessageFlowException {
        return getRawMessageContent(getRawMessageContentRequest, ResponseTransformer.toBytes());
    }

    /**
     * <p>
     * Retrieves the raw content of an in-transit email message, in MIME format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRawMessageContentRequest.Builder} avoiding the
     * need to create one manually via {@link GetRawMessageContentRequest#builder()}
     * </p>
     *
     * @param getRawMessageContentRequest
     *        A {@link Consumer} that will call methods on {@link GetRawMessageContentRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         The raw content of the email message, in MIME format.
     *         </p>
     *         '.
     * @throws ResourceNotFoundException
     *         The requested email message is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailMessageFlowException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailMessageFlowClient.GetRawMessageContent
     * @see #getObject(getRawMessageContent, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmailmessageflow-2019-05-01/GetRawMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<GetRawMessageContentResponse> getRawMessageContentAsBytes(
            Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return getRawMessageContentAsBytes(GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("workmailmessageflow");
    }
}
