/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessEffect {
    ALLOW("ALLOW"),
    DENY("DENY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessEffect> VALUE_MAP;
    private final String value;

    private AccessEffect(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessEffect fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessEffect> knownValues() {
        EnumSet<AccessEffect> knownValues = EnumSet.allOf(AccessEffect.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessEffect.class, AccessEffect::toString);
    }
}

