/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPersonalAccessTokenMetadataRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, GetPersonalAccessTokenMetadataRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(GetPersonalAccessTokenMetadataRequest.getter(GetPersonalAccessTokenMetadataRequest::organizationId)).setter(GetPersonalAccessTokenMetadataRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> PERSONAL_ACCESS_TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersonalAccessTokenId").getter(GetPersonalAccessTokenMetadataRequest.getter(GetPersonalAccessTokenMetadataRequest::personalAccessTokenId)).setter(GetPersonalAccessTokenMetadataRequest.setter(Builder::personalAccessTokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalAccessTokenId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, PERSONAL_ACCESS_TOKEN_ID_FIELD));
    private final String organizationId;
    private final String personalAccessTokenId;

    private GetPersonalAccessTokenMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.personalAccessTokenId = builder.personalAccessTokenId;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String personalAccessTokenId() {
        return this.personalAccessTokenId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalAccessTokenId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersonalAccessTokenMetadataRequest)) {
            return false;
        }
        GetPersonalAccessTokenMetadataRequest other = (GetPersonalAccessTokenMetadataRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.personalAccessTokenId(), other.personalAccessTokenId());
    }

    public final String toString() {
        return ToString.builder((String)"GetPersonalAccessTokenMetadataRequest").add("OrganizationId", (Object)this.organizationId()).add("PersonalAccessTokenId", (Object)this.personalAccessTokenId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "PersonalAccessTokenId": {
                return Optional.ofNullable(clazz.cast(this.personalAccessTokenId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPersonalAccessTokenMetadataRequest, T> g) {
        return obj -> g.apply((GetPersonalAccessTokenMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String personalAccessTokenId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersonalAccessTokenMetadataRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.personalAccessTokenId(model.personalAccessTokenId);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getPersonalAccessTokenId() {
            return this.personalAccessTokenId;
        }

        public final void setPersonalAccessTokenId(String personalAccessTokenId) {
            this.personalAccessTokenId = personalAccessTokenId;
        }

        @Override
        public final Builder personalAccessTokenId(String personalAccessTokenId) {
            this.personalAccessTokenId = personalAccessTokenId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPersonalAccessTokenMetadataRequest build() {
            return new GetPersonalAccessTokenMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPersonalAccessTokenMetadataRequest> {
        public Builder organizationId(String var1);

        public Builder personalAccessTokenId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

