/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;

public class ListResourceDelegatesIterable
implements SdkIterable<ListResourceDelegatesResponse> {
    private final WorkMailClient client;
    private final ListResourceDelegatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceDelegatesIterable(WorkMailClient client, ListResourceDelegatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceDelegatesResponseFetcher();
    }

    public Iterator<ListResourceDelegatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListResourceDelegatesResponseFetcher
    implements SyncPageFetcher<ListResourceDelegatesResponse> {
        private ListResourceDelegatesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceDelegatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceDelegatesResponse nextPage(ListResourceDelegatesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceDelegatesIterable.this.client.listResourceDelegates(ListResourceDelegatesIterable.this.firstRequest);
            }
            return ListResourceDelegatesIterable.this.client.listResourceDelegates((ListResourceDelegatesRequest)((Object)ListResourceDelegatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

