/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;

public class ListMailboxPermissionsIterable
implements SdkIterable<ListMailboxPermissionsResponse> {
    private final WorkMailClient client;
    private final ListMailboxPermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMailboxPermissionsIterable(WorkMailClient client, ListMailboxPermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMailboxPermissionsResponseFetcher();
    }

    public Iterator<ListMailboxPermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMailboxPermissionsResponseFetcher
    implements SyncPageFetcher<ListMailboxPermissionsResponse> {
        private ListMailboxPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMailboxPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMailboxPermissionsResponse nextPage(ListMailboxPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListMailboxPermissionsIterable.this.client.listMailboxPermissions(ListMailboxPermissionsIterable.this.firstRequest);
            }
            return ListMailboxPermissionsIterable.this.client.listMailboxPermissions((ListMailboxPermissionsRequest)((Object)ListMailboxPermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

