/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.Delegate;
import software.amazon.awssdk.services.workmail.model.ResourceDelegatesCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceDelegatesResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListResourceDelegatesResponse> {
    private static final SdkField<List<Delegate>> DELEGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Delegates").getter(ListResourceDelegatesResponse.getter(ListResourceDelegatesResponse::delegates)).setter(ListResourceDelegatesResponse.setter(Builder::delegates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delegates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Delegate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceDelegatesResponse.getter(ListResourceDelegatesResponse::nextToken)).setter(ListResourceDelegatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Delegate> delegates;
    private final String nextToken;

    private ListResourceDelegatesResponse(BuilderImpl builder) {
        super(builder);
        this.delegates = builder.delegates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDelegates() {
        return this.delegates != null && !(this.delegates instanceof SdkAutoConstructList);
    }

    public final List<Delegate> delegates() {
        return this.delegates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegates() ? this.delegates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceDelegatesResponse)) {
            return false;
        }
        ListResourceDelegatesResponse other = (ListResourceDelegatesResponse)((Object)obj);
        return this.hasDelegates() == other.hasDelegates() && Objects.equals(this.delegates(), other.delegates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceDelegatesResponse").add("Delegates", this.hasDelegates() ? this.delegates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Delegates": {
                return Optional.ofNullable(clazz.cast(this.delegates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceDelegatesResponse, T> g) {
        return obj -> g.apply((ListResourceDelegatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<Delegate> delegates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceDelegatesResponse model) {
            super(model);
            this.delegates(model.delegates);
            this.nextToken(model.nextToken);
        }

        public final Collection<Delegate.Builder> getDelegates() {
            if (this.delegates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.delegates != null ? (Collection)this.delegates.stream().map(Delegate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder delegates(Collection<Delegate> delegates) {
            this.delegates = ResourceDelegatesCopier.copy(delegates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegates(Delegate ... delegates) {
            this.delegates(Arrays.asList(delegates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegates(Consumer<Delegate.Builder> ... delegates) {
            this.delegates(Stream.of(delegates).map(c -> (Delegate)((Delegate.Builder)Delegate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDelegates(Collection<Delegate.BuilderImpl> delegates) {
            this.delegates = ResourceDelegatesCopier.copyFromBuilder(delegates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceDelegatesResponse build() {
            return new ListResourceDelegatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceDelegatesResponse> {
        public Builder delegates(Collection<Delegate> var1);

        public Builder delegates(Delegate ... var1);

        public Builder delegates(Consumer<Delegate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

