/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The representation of a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Resource::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(Resource::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Resource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Resource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Resource::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EnabledDate").getter(getter(Resource::enabledDate)).setter(setter(Builder::enabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()).build();

    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisabledDate").getter(getter(Resource::disabledDate)).setter(setter(Builder::disabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EMAIL_FIELD,
            NAME_FIELD, TYPE_FIELD, STATE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String email;

    private final String name;

    private final String type;

    private final String state;

    private final Instant enabledDate;

    private final Instant disabledDate;

    private Resource(BuilderImpl builder) {
        this.id = builder.id;
        this.email = builder.email;
        this.name = builder.name;
        this.type = builder.type;
        this.state = builder.state;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
    }

    /**
     * <p>
     * The identifier of the resource.
     * </p>
     * 
     * @return The identifier of the resource.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The email of the resource.
     * </p>
     * 
     * @return The email of the resource.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the resource: equipment or room.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the resource: equipment or room.
     * @see ResourceType
     */
    public final ResourceType type() {
        return ResourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the resource: equipment or room.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the resource: equipment or room.
     * @see ResourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The state of the resource, which can be ENABLED, DISABLED, or DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the resource, which can be ENABLED, DISABLED, or DELETED.
     * @see EntityState
     */
    public final EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * The state of the resource, which can be ENABLED, DISABLED, or DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the resource, which can be ENABLED, DISABLED, or DELETED.
     * @see EntityState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date indicating when the resource was enabled for Amazon WorkMail use.
     * </p>
     * 
     * @return The date indicating when the resource was enabled for Amazon WorkMail use.
     */
    public final Instant enabledDate() {
        return enabledDate;
    }

    /**
     * <p>
     * The date indicating when the resource was disabled from Amazon WorkMail use.
     * </p>
     * 
     * @return The date indicating when the resource was disabled from Amazon WorkMail use.
     */
    public final Instant disabledDate() {
        return disabledDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(disabledDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(email(), other.email()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(enabledDate(), other.enabledDate()) && Objects.equals(disabledDate(), other.disabledDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("Id", id()).add("Email", email()).add("Name", name()).add("Type", typeAsString())
                .add("State", stateAsString()).add("EnabledDate", enabledDate()).add("DisabledDate", disabledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EnabledDate":
            return Optional.ofNullable(clazz.cast(enabledDate()));
        case "DisabledDate":
            return Optional.ofNullable(clazz.cast(disabledDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The identifier of the resource.
         * </p>
         * 
         * @param id
         *        The identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The email of the resource.
         * </p>
         * 
         * @param email
         *        The email of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the resource: equipment or room.
         * </p>
         * 
         * @param type
         *        The type of the resource: equipment or room.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the resource: equipment or room.
         * </p>
         * 
         * @param type
         *        The type of the resource: equipment or room.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(ResourceType type);

        /**
         * <p>
         * The state of the resource, which can be ENABLED, DISABLED, or DELETED.
         * </p>
         * 
         * @param state
         *        The state of the resource, which can be ENABLED, DISABLED, or DELETED.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the resource, which can be ENABLED, DISABLED, or DELETED.
         * </p>
         * 
         * @param state
         *        The state of the resource, which can be ENABLED, DISABLED, or DELETED.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);

        /**
         * <p>
         * The date indicating when the resource was enabled for Amazon WorkMail use.
         * </p>
         * 
         * @param enabledDate
         *        The date indicating when the resource was enabled for Amazon WorkMail use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledDate(Instant enabledDate);

        /**
         * <p>
         * The date indicating when the resource was disabled from Amazon WorkMail use.
         * </p>
         * 
         * @param disabledDate
         *        The date indicating when the resource was disabled from Amazon WorkMail use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledDate(Instant disabledDate);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String email;

        private String name;

        private String type;

        private String state;

        private Instant enabledDate;

        private Instant disabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            id(model.id);
            email(model.email);
            name(model.name);
            type(model.type);
            state(model.state);
            enabledDate(model.enabledDate);
            disabledDate(model.disabledDate);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getEnabledDate() {
            return enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        public final Instant getDisabledDate() {
            return disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
