/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The representation of an Amazon WorkMail user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(User::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> USER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::userRoleAsString)).setter(setter(Builder::userRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()).build();

    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(User::enabledDate)).setter(setter(Builder::enabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()).build();

    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(User::disabledDate)).setter(setter(Builder::disabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EMAIL_FIELD,
            NAME_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, USER_ROLE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String email;

    private final String name;

    private final String displayName;

    private final String state;

    private final String userRole;

    private final Instant enabledDate;

    private final Instant disabledDate;

    private User(BuilderImpl builder) {
        this.id = builder.id;
        this.email = builder.email;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.userRole = builder.userRole;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
    }

    /**
     * <p>
     * The identifier of the user.
     * </p>
     * 
     * @return The identifier of the user.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The email of the user.
     * </p>
     * 
     * @return The email of the user.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The display name of the user.
     * </p>
     * 
     * @return The display name of the user.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The state of the user, which can be ENABLED, DISABLED, or DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the user, which can be ENABLED, DISABLED, or DELETED.
     * @see EntityState
     */
    public EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * The state of the user, which can be ENABLED, DISABLED, or DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the user, which can be ENABLED, DISABLED, or DELETED.
     * @see EntityState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The role of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return The role of the user.
     * @see UserRole
     */
    public UserRole userRole() {
        return UserRole.fromValue(userRole);
    }

    /**
     * <p>
     * The role of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return The role of the user.
     * @see UserRole
     */
    public String userRoleAsString() {
        return userRole;
    }

    /**
     * <p>
     * The date indicating when the user was enabled for Amazon WorkMail use.
     * </p>
     * 
     * @return The date indicating when the user was enabled for Amazon WorkMail use.
     */
    public Instant enabledDate() {
        return enabledDate;
    }

    /**
     * <p>
     * The date indicating when the user was disabled from Amazon WorkMail use.
     * </p>
     * 
     * @return The date indicating when the user was disabled from Amazon WorkMail use.
     */
    public Instant disabledDate() {
        return disabledDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(disabledDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(email(), other.email()) && Objects.equals(name(), other.name())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(userRoleAsString(), other.userRoleAsString())
                && Objects.equals(enabledDate(), other.enabledDate()) && Objects.equals(disabledDate(), other.disabledDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("User").add("Id", id()).add("Email", email()).add("Name", name())
                .add("DisplayName", displayName()).add("State", stateAsString()).add("UserRole", userRoleAsString())
                .add("EnabledDate", enabledDate()).add("DisabledDate", disabledDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "UserRole":
            return Optional.ofNullable(clazz.cast(userRoleAsString()));
        case "EnabledDate":
            return Optional.ofNullable(clazz.cast(enabledDate()));
        case "DisabledDate":
            return Optional.ofNullable(clazz.cast(disabledDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The identifier of the user.
         * </p>
         * 
         * @param id
         *        The identifier of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The email of the user.
         * </p>
         * 
         * @param email
         *        The email of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param name
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The display name of the user.
         * </p>
         * 
         * @param displayName
         *        The display name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The state of the user, which can be ENABLED, DISABLED, or DELETED.
         * </p>
         * 
         * @param state
         *        The state of the user, which can be ENABLED, DISABLED, or DELETED.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the user, which can be ENABLED, DISABLED, or DELETED.
         * </p>
         * 
         * @param state
         *        The state of the user, which can be ENABLED, DISABLED, or DELETED.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);

        /**
         * <p>
         * The role of the user.
         * </p>
         * 
         * @param userRole
         *        The role of the user.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(String userRole);

        /**
         * <p>
         * The role of the user.
         * </p>
         * 
         * @param userRole
         *        The role of the user.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(UserRole userRole);

        /**
         * <p>
         * The date indicating when the user was enabled for Amazon WorkMail use.
         * </p>
         * 
         * @param enabledDate
         *        The date indicating when the user was enabled for Amazon WorkMail use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledDate(Instant enabledDate);

        /**
         * <p>
         * The date indicating when the user was disabled from Amazon WorkMail use.
         * </p>
         * 
         * @param disabledDate
         *        The date indicating when the user was disabled from Amazon WorkMail use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledDate(Instant disabledDate);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String email;

        private String name;

        private String displayName;

        private String state;

        private String userRole;

        private Instant enabledDate;

        private Instant disabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            id(model.id);
            email(model.email);
            name(model.name);
            displayName(model.displayName);
            state(model.state);
            userRole(model.userRole);
            enabledDate(model.enabledDate);
            disabledDate(model.disabledDate);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getUserRoleAsString() {
            return userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        @Override
        public final Builder userRole(UserRole userRole) {
            this.userRole(userRole == null ? null : userRole.toString());
            return this;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        public final Instant getEnabledDate() {
            return enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        public final Instant getDisabledDate() {
            return disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
