/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMailboxDetailsResponse extends WorkMailResponse implements
        ToCopyableBuilder<GetMailboxDetailsResponse.Builder, GetMailboxDetailsResponse> {
    private static final SdkField<Integer> MAILBOX_QUOTA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetMailboxDetailsResponse::mailboxQuota)).setter(setter(Builder::mailboxQuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailboxQuota").build()).build();

    private static final SdkField<Double> MAILBOX_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(GetMailboxDetailsResponse::mailboxSize)).setter(setter(Builder::mailboxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailboxSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAILBOX_QUOTA_FIELD,
            MAILBOX_SIZE_FIELD));

    private final Integer mailboxQuota;

    private final Double mailboxSize;

    private GetMailboxDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.mailboxQuota = builder.mailboxQuota;
        this.mailboxSize = builder.mailboxSize;
    }

    /**
     * <p>
     * The maximum allowed mailbox size, in MB, for the specified user.
     * </p>
     * 
     * @return The maximum allowed mailbox size, in MB, for the specified user.
     */
    public Integer mailboxQuota() {
        return mailboxQuota;
    }

    /**
     * <p>
     * The current mailbox size, in MB, for the specified user.
     * </p>
     * 
     * @return The current mailbox size, in MB, for the specified user.
     */
    public Double mailboxSize() {
        return mailboxSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mailboxQuota());
        hashCode = 31 * hashCode + Objects.hashCode(mailboxSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMailboxDetailsResponse)) {
            return false;
        }
        GetMailboxDetailsResponse other = (GetMailboxDetailsResponse) obj;
        return Objects.equals(mailboxQuota(), other.mailboxQuota()) && Objects.equals(mailboxSize(), other.mailboxSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMailboxDetailsResponse").add("MailboxQuota", mailboxQuota())
                .add("MailboxSize", mailboxSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailboxQuota":
            return Optional.ofNullable(clazz.cast(mailboxQuota()));
        case "MailboxSize":
            return Optional.ofNullable(clazz.cast(mailboxSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMailboxDetailsResponse, T> g) {
        return obj -> g.apply((GetMailboxDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMailboxDetailsResponse> {
        /**
         * <p>
         * The maximum allowed mailbox size, in MB, for the specified user.
         * </p>
         * 
         * @param mailboxQuota
         *        The maximum allowed mailbox size, in MB, for the specified user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailboxQuota(Integer mailboxQuota);

        /**
         * <p>
         * The current mailbox size, in MB, for the specified user.
         * </p>
         * 
         * @param mailboxSize
         *        The current mailbox size, in MB, for the specified user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailboxSize(Double mailboxSize);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private Integer mailboxQuota;

        private Double mailboxSize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMailboxDetailsResponse model) {
            super(model);
            mailboxQuota(model.mailboxQuota);
            mailboxSize(model.mailboxSize);
        }

        public final Integer getMailboxQuota() {
            return mailboxQuota;
        }

        @Override
        public final Builder mailboxQuota(Integer mailboxQuota) {
            this.mailboxQuota = mailboxQuota;
            return this;
        }

        public final void setMailboxQuota(Integer mailboxQuota) {
            this.mailboxQuota = mailboxQuota;
        }

        public final Double getMailboxSize() {
            return mailboxSize;
        }

        @Override
        public final Builder mailboxSize(Double mailboxSize) {
            this.mailboxSize = mailboxSize;
            return this;
        }

        public final void setMailboxSize(Double mailboxSize) {
            this.mailboxSize = mailboxSize;
        }

        @Override
        public GetMailboxDetailsResponse build() {
            return new GetMailboxDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
