/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWebsiteCertificateAuthorityResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, DescribeWebsiteCertificateAuthorityResponse> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWebsiteCertificateAuthorityResponse.getter(DescribeWebsiteCertificateAuthorityResponse::certificate)).setter(DescribeWebsiteCertificateAuthorityResponse.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeWebsiteCertificateAuthorityResponse.getter(DescribeWebsiteCertificateAuthorityResponse::createdTime)).setter(DescribeWebsiteCertificateAuthorityResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWebsiteCertificateAuthorityResponse.getter(DescribeWebsiteCertificateAuthorityResponse::displayName)).setter(DescribeWebsiteCertificateAuthorityResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, CREATED_TIME_FIELD, DISPLAY_NAME_FIELD));
    private final String certificate;
    private final Instant createdTime;
    private final String displayName;

    private DescribeWebsiteCertificateAuthorityResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.createdTime = builder.createdTime;
        this.displayName = builder.displayName;
    }

    public String certificate() {
        return this.certificate;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWebsiteCertificateAuthorityResponse)) {
            return false;
        }
        DescribeWebsiteCertificateAuthorityResponse other = (DescribeWebsiteCertificateAuthorityResponse)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.displayName(), other.displayName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWebsiteCertificateAuthorityResponse").add("Certificate", (Object)this.certificate()).add("CreatedTime", (Object)this.createdTime()).add("DisplayName", (Object)this.displayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWebsiteCertificateAuthorityResponse, T> g) {
        return obj -> g.apply((DescribeWebsiteCertificateAuthorityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private String certificate;
        private Instant createdTime;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWebsiteCertificateAuthorityResponse model) {
            super(model);
            this.certificate(model.certificate);
            this.createdTime(model.createdTime);
            this.displayName(model.displayName);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public DescribeWebsiteCertificateAuthorityResponse build() {
            return new DescribeWebsiteCertificateAuthorityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWebsiteCertificateAuthorityResponse> {
        public Builder certificate(String var1);

        public Builder createdTime(Instant var1);

        public Builder displayName(String var1);
    }
}

