/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDevicePolicyConfigurationResponse extends WorkLinkResponse implements
        ToCopyableBuilder<DescribeDevicePolicyConfigurationResponse.Builder, DescribeDevicePolicyConfigurationResponse> {
    private static final SdkField<String> DEVICE_CA_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDevicePolicyConfigurationResponse::deviceCaCertificate))
            .setter(setter(Builder::deviceCaCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCaCertificate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_CA_CERTIFICATE_FIELD));

    private final String deviceCaCertificate;

    private DescribeDevicePolicyConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.deviceCaCertificate = builder.deviceCaCertificate;
    }

    /**
     * <p>
     * The certificate chain, including intermediate certificates and the root certificate authority certificate used to
     * issue device certificates.
     * </p>
     * 
     * @return The certificate chain, including intermediate certificates and the root certificate authority certificate
     *         used to issue device certificates.
     */
    public String deviceCaCertificate() {
        return deviceCaCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceCaCertificate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDevicePolicyConfigurationResponse)) {
            return false;
        }
        DescribeDevicePolicyConfigurationResponse other = (DescribeDevicePolicyConfigurationResponse) obj;
        return Objects.equals(deviceCaCertificate(), other.deviceCaCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDevicePolicyConfigurationResponse").add("DeviceCaCertificate", deviceCaCertificate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceCaCertificate":
            return Optional.ofNullable(clazz.cast(deviceCaCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDevicePolicyConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeDevicePolicyConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDevicePolicyConfigurationResponse> {
        /**
         * <p>
         * The certificate chain, including intermediate certificates and the root certificate authority certificate
         * used to issue device certificates.
         * </p>
         * 
         * @param deviceCaCertificate
         *        The certificate chain, including intermediate certificates and the root certificate authority
         *        certificate used to issue device certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCaCertificate(String deviceCaCertificate);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private String deviceCaCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDevicePolicyConfigurationResponse model) {
            super(model);
            deviceCaCertificate(model.deviceCaCertificate);
        }

        public final String getDeviceCaCertificate() {
            return deviceCaCertificate;
        }

        @Override
        public final Builder deviceCaCertificate(String deviceCaCertificate) {
            this.deviceCaCertificate = deviceCaCertificate;
            return this;
        }

        public final void setDeviceCaCertificate(String deviceCaCertificate) {
            this.deviceCaCertificate = deviceCaCertificate;
        }

        @Override
        public DescribeDevicePolicyConfigurationResponse build() {
            return new DescribeDevicePolicyConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
