/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateWebsiteCertificateAuthorityResponse extends WorkLinkResponse implements
        ToCopyableBuilder<AssociateWebsiteCertificateAuthorityResponse.Builder, AssociateWebsiteCertificateAuthorityResponse> {
    private static final SdkField<String> WEBSITE_CA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateWebsiteCertificateAuthorityResponse::websiteCaId)).setter(setter(Builder::websiteCaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteCaId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSITE_CA_ID_FIELD));

    private final String websiteCaId;

    private AssociateWebsiteCertificateAuthorityResponse(BuilderImpl builder) {
        super(builder);
        this.websiteCaId = builder.websiteCaId;
    }

    /**
     * <p>
     * A unique identifier for the CA.
     * </p>
     * 
     * @return A unique identifier for the CA.
     */
    public String websiteCaId() {
        return websiteCaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(websiteCaId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWebsiteCertificateAuthorityResponse)) {
            return false;
        }
        AssociateWebsiteCertificateAuthorityResponse other = (AssociateWebsiteCertificateAuthorityResponse) obj;
        return Objects.equals(websiteCaId(), other.websiteCaId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateWebsiteCertificateAuthorityResponse").add("WebsiteCaId", websiteCaId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebsiteCaId":
            return Optional.ofNullable(clazz.cast(websiteCaId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateWebsiteCertificateAuthorityResponse, T> g) {
        return obj -> g.apply((AssociateWebsiteCertificateAuthorityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateWebsiteCertificateAuthorityResponse> {
        /**
         * <p>
         * A unique identifier for the CA.
         * </p>
         * 
         * @param websiteCaId
         *        A unique identifier for the CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteCaId(String websiteCaId);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private String websiteCaId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWebsiteCertificateAuthorityResponse model) {
            super(model);
            websiteCaId(model.websiteCaId);
        }

        public final String getWebsiteCaId() {
            return websiteCaId;
        }

        @Override
        public final Builder websiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
            return this;
        }

        public final void setWebsiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
        }

        @Override
        public AssociateWebsiteCertificateAuthorityResponse build() {
            return new AssociateWebsiteCertificateAuthorityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
