/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDevicePolicyConfigurationRequest extends WorkLinkRequest implements
        ToCopyableBuilder<UpdateDevicePolicyConfigurationRequest.Builder, UpdateDevicePolicyConfigurationRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDevicePolicyConfigurationRequest::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> DEVICE_CA_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDevicePolicyConfigurationRequest::deviceCaCertificate))
            .setter(setter(Builder::deviceCaCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCaCertificate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD,
            DEVICE_CA_CERTIFICATE_FIELD));

    private final String fleetArn;

    private final String deviceCaCertificate;

    private UpdateDevicePolicyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.deviceCaCertificate = builder.deviceCaCertificate;
    }

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @return The ARN of the fleet.
     */
    public String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The certificate chain, including intermediate certificates and the root certificate authority certificate used to
     * issue device certificates.
     * </p>
     * 
     * @return The certificate chain, including intermediate certificates and the root certificate authority certificate
     *         used to issue device certificates.
     */
    public String deviceCaCertificate() {
        return deviceCaCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceCaCertificate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevicePolicyConfigurationRequest)) {
            return false;
        }
        UpdateDevicePolicyConfigurationRequest other = (UpdateDevicePolicyConfigurationRequest) obj;
        return Objects.equals(fleetArn(), other.fleetArn()) && Objects.equals(deviceCaCertificate(), other.deviceCaCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDevicePolicyConfigurationRequest").add("FleetArn", fleetArn())
                .add("DeviceCaCertificate", deviceCaCertificate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "DeviceCaCertificate":
            return Optional.ofNullable(clazz.cast(deviceCaCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDevicePolicyConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDevicePolicyConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDevicePolicyConfigurationRequest> {
        /**
         * <p>
         * The ARN of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The ARN of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The certificate chain, including intermediate certificates and the root certificate authority certificate
         * used to issue device certificates.
         * </p>
         * 
         * @param deviceCaCertificate
         *        The certificate chain, including intermediate certificates and the root certificate authority
         *        certificate used to issue device certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCaCertificate(String deviceCaCertificate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkLinkRequest.BuilderImpl implements Builder {
        private String fleetArn;

        private String deviceCaCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevicePolicyConfigurationRequest model) {
            super(model);
            fleetArn(model.fleetArn);
            deviceCaCertificate(model.deviceCaCertificate);
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getDeviceCaCertificate() {
            return deviceCaCertificate;
        }

        @Override
        public final Builder deviceCaCertificate(String deviceCaCertificate) {
            this.deviceCaCertificate = deviceCaCertificate;
            return this;
        }

        public final void setDeviceCaCertificate(String deviceCaCertificate) {
            this.deviceCaCertificate = deviceCaCertificate;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDevicePolicyConfigurationRequest build() {
            return new UpdateDevicePolicyConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
