/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.OrderByFieldType;
import software.amazon.awssdk.services.workdocs.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSortResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchSortResult> {
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Field").getter(SearchSortResult.getter(SearchSortResult::fieldAsString)).setter(SearchSortResult.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Order").getter(SearchSortResult.getter(SearchSortResult::orderAsString)).setter(SearchSortResult.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Field", FIELD_FIELD);
            this.put("Order", ORDER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String field;
    private final String order;

    private SearchSortResult(BuilderImpl builder) {
        this.field = builder.field;
        this.order = builder.order;
    }

    public final OrderByFieldType field() {
        return OrderByFieldType.fromValue(this.field);
    }

    public final String fieldAsString() {
        return this.field;
    }

    public final SortOrder order() {
        return SortOrder.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSortResult)) {
            return false;
        }
        SearchSortResult other = (SearchSortResult)obj;
        return Objects.equals(this.fieldAsString(), other.fieldAsString()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSortResult").add("Field", (Object)this.fieldAsString()).add("Order", (Object)this.orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Field": {
                return Optional.ofNullable(clazz.cast(this.fieldAsString()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchSortResult, T> g) {
        return obj -> g.apply((SearchSortResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String field;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSortResult model) {
            this.field(model.field);
            this.order(model.order);
        }

        public final String getField() {
            return this.field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(OrderByFieldType field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(SortOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public SearchSortResult build() {
            return new SearchSortResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchSortResult> {
        public Builder field(String var1);

        public Builder field(OrderByFieldType var1);

        public Builder order(String var1);

        public Builder order(SortOrder var1);
    }
}

